/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.instrumentation.changelog;

import io.datarouter.instrumentation.changelog.ChangelogDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public interface ChangelogRecorder {
    public void record(DatarouterChangelogDto var1);

    public void update(ChangelogDto var1);

    public static class DatarouterChangelogDto {
        public final String changelogType;
        public final String name;
        public final String action;
        public final String username;
        public final Optional<String> comment;
        public final Optional<String> note;
        public final List<String> additionalSendTos;
        public final boolean sendEmail;
        public final boolean includeMainDatarouterAdmin;
        public final boolean includeSubscribers;

        private DatarouterChangelogDto(String changelogType, String name, String action, String username, Optional<String> comment, Optional<String> note, List<String> additionalSendTos, boolean sendEmail, boolean includeMainDatarouterAdmin, boolean includeSubscribers) {
            this.changelogType = changelogType;
            this.name = name;
            this.action = action;
            this.username = username;
            this.comment = comment;
            this.note = note;
            this.additionalSendTos = additionalSendTos;
            this.sendEmail = sendEmail;
            this.includeMainDatarouterAdmin = includeMainDatarouterAdmin;
            this.includeSubscribers = includeSubscribers;
        }
    }

    public static class DatarouterChangelogDtoBuilder {
        public final String changelogType;
        public final String name;
        public final String action;
        public final String username;
        public Optional<String> comment = Optional.empty();
        public Optional<String> note = Optional.empty();
        public List<String> additionalSendTos = new ArrayList<String>();
        public boolean sendEmail = false;
        public boolean includeMainDatarouterAdmin = true;
        public boolean includeSubscribers = true;

        public DatarouterChangelogDtoBuilder(String changelogType, String name, String action, String username) {
            this.changelogType = changelogType;
            this.name = name;
            this.action = action;
            this.username = username;
        }

        public DatarouterChangelogDtoBuilder sendEmail() {
            this.sendEmail = true;
            return this;
        }

        public DatarouterChangelogDtoBuilder withComment(String comment) {
            this.comment = Optional.of(comment);
            return this;
        }

        public DatarouterChangelogDtoBuilder withNote(String note) {
            this.note = Optional.of(note);
            return this;
        }

        public DatarouterChangelogDtoBuilder excludeMainDatarouterAdmin() {
            this.includeMainDatarouterAdmin = false;
            return this;
        }

        public DatarouterChangelogDtoBuilder excludeSubscribers() {
            this.includeSubscribers = false;
            return this;
        }

        public DatarouterChangelogDtoBuilder additionalSendTos(String additionalSendTo) {
            this.additionalSendTos.add(additionalSendTo);
            return this;
        }

        public DatarouterChangelogDto build() {
            return new DatarouterChangelogDto(this.changelogType, this.name, this.action, this.username, this.comment, this.note, this.additionalSendTos, this.sendEmail, this.includeMainDatarouterAdmin, this.includeSubscribers);
        }
    }

    public static class NoOpChangelogRecorder
    implements ChangelogRecorder {
        @Override
        public void record(DatarouterChangelogDto changelogDto) {
        }

        @Override
        public void update(ChangelogDto changelogDto) {
        }
    }
}

