/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.subentity;

import io.datarouter.client.hbase.node.subentity.HBaseSubEntityResultParser;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.util.lang.ReflectionTool;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class HBaseSubEntityResultParserFactory {
    public static <EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> HBaseSubEntityResultParser<EK, PK, D> create(EntityFieldInfo<EK, E> entityFieldInfo, DatabeanFieldInfo<PK, D, F> fieldInfo) {
        Supplier databeanSupplier = fieldInfo.getDatabeanSupplier();
        int prefixByteLength = entityFieldInfo.getEntityPartitioner().getNumPrefixBytes();
        return new HBaseSubEntityResultParser(fieldInfo.getPrimaryKeySupplier(), entityFieldInfo.getEntityKeySupplier(), fieldInfo.getEkFields(), fieldInfo.getEkPkFields(), fieldInfo.getPostEkPkKeyFields(), fieldInfo.getNonKeyFieldByColumnName(), prefixByteLength, fieldInfo.getEntityColumnPrefixBytes(), fieldInfo.getKeyJavaField(), databeanSupplier);
    }

    public static <EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> HBaseSubEntityResultParser<EK, PK, D> create(Supplier<EK> entityKeySupplier, Supplier<PK> primaryKeySupplier, Supplier<D> databeanSupplier, F databeanFielder, int numPrefixBytes, byte[] entityColumnPrefixBytes) {
        Databean prototypeDatabean = (Databean)databeanSupplier.get();
        EntityPrimaryKey primaryKey = (EntityPrimaryKey)prototypeDatabean.getKey();
        Map<String, io.datarouter.model.field.Field<?>> nonKeyFieldsByColumnNames = databeanFielder.getNonKeyFields(prototypeDatabean).stream().collect(Collectors.toMap(field -> field.getKey().getColumnName(), Function.identity()));
        Field keyJavaField = ReflectionTool.getDeclaredFieldFromAncestors(prototypeDatabean.getClass(), (String)prototypeDatabean.getKeyFieldName());
        return new HBaseSubEntityResultParser<EK, PK, D>(primaryKeySupplier, entityKeySupplier, primaryKey.getEntityKey().getFields(), primaryKey.getEntityKeyFields(), primaryKey.getPostEntityKeyFields(), nonKeyFieldsByColumnNames, numPrefixBytes, entityColumnPrefixBytes, keyJavaField, databeanSupplier);
    }
}

