/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.entity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.node.entity.HBaseEntityQueryBuilder;
import io.datarouter.client.hbase.node.entity.HBaseEntityResultParser;
import io.datarouter.client.hbase.util.HBaseResultScannerTool;
import io.datarouter.client.hbase.util.HBaseTableTool;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientTableNodeNames;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.entity.BasePhysicalEntityNode;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.util.DatarouterCounters;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;

public class HBaseEntityNode<EK extends EntityKey<EK>, E extends Entity<EK>>
extends BasePhysicalEntityNode<EK, E> {
    private static final int DEFAULT_GET_KEYS_LIMIT = 1000;
    protected final NodeFactory nodeFactory;
    protected final EntityNodeParams<EK, E> entityNodeParams;
    private final ClientTableNodeNames clientTableNodeNames;
    private final HBaseEntityQueryBuilder<EK, E> queryBuilder;
    private final HBaseEntityResultParser<EK, E> resultParser;
    private final HBaseClientManager hBaseClientManager;
    private final ClientType<?, ?> clientType;

    public HBaseEntityNode(HBaseClientManager hBaseClientManager, NodeFactory nodeFactory, EntityNodeParams<EK, E> entityNodeParams, ClientTableNodeNames clientTableNodeNames, ClientType<?, ?> clientType) {
        super(entityNodeParams, clientTableNodeNames);
        this.hBaseClientManager = hBaseClientManager;
        this.nodeFactory = nodeFactory;
        this.entityNodeParams = entityNodeParams;
        this.clientTableNodeNames = clientTableNodeNames;
        this.queryBuilder = new HBaseEntityQueryBuilder(this.getEntityFieldInfo());
        this.resultParser = new HBaseEntityResultParser(this.entityFieldInfo, this.getNodeByQualifierPrefix(), this.entityFieldInfo.getEntityKeySupplier(), this.entityFieldInfo.getEntityPartitioner().getNumPrefixBytes(), this.entityFieldInfo.getSampleEntityKey().getFields());
        this.clientType = clientType;
    }

    public List<E> getEntities(Collection<EK> entityKeys, Config config) {
        Result[] hbaseResults;
        if (entityKeys == null || entityKeys.isEmpty()) {
            return List.of();
        }
        List<Get> gets = entityKeys.stream().map(this.queryBuilder::getRowBytesWithPartition).map(Get::new).collect(Collectors.toList());
        try {
            Throwable throwable = null;
            Object var7_7 = null;
            try (Table table = this.getTable();){
                hbaseResults = HBaseTableTool.getUnchecked(table, gets);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List entities = Arrays.stream(hbaseResults).filter(result -> !result.isEmpty()).map(this.resultParser::parseEntity).filter(Entity::notEmpty).sorted().collect(Collectors.toList());
        long numDatabeans = entities.stream().mapToLong(Entity::getNumDatabeans).sum();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"entity databeans", (String)this.getClientName(), (String)this.clientTableNodeNames.getNodeName(), (long)numDatabeans);
        return entities;
    }

    public void deleteMultiEntities(Collection<EK> eks, Config config) {
        Scanner.of(eks).map(this.queryBuilder::getRowBytesWithPartition).map(Delete::new).batch(config.findInputBatchSize().orElse(100).intValue()).forEach(deletes -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Table table = this.getTable();){
                    HBaseTableTool.deleteUnchecked(table, deletes);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<EK> listEntityKeys(EK startKey, boolean startKeyInclusive, Config config) {
        int limit = config.findLimit().orElse(1000);
        return this.queryBuilder.getScanForEachPartition(startKey, startKeyInclusive).stream().map(scan -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    List<Result> list;
                    ResultScanner resultScanner;
                    Table table;
                    block18: {
                        block17: {
                            table = this.getTable();
                            resultScanner = HBaseTableTool.getResultScanner(table, scan);
                            list = HBaseResultScannerTool.resultScannerNext(resultScanner, limit);
                            if (resultScanner == null) break block17;
                            resultScanner.close();
                        }
                        if (table == null) break block18;
                        table.close();
                    }
                    return list;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (resultScanner != null) {
                                    resultScanner.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (table != null) {
                                    table.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).map(Result::getRow).map(this.resultParser::getEkFromRowBytes).sorted().limit(limit).collect(Collectors.toList());
    }

    private Table getTable() {
        return this.hBaseClientManager.getTable(this.clientTableNodeNames.getClientId(), this.clientTableNodeNames.getTableName());
    }
}

