/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.instrumentation.count.Counters;

public class DatarouterHBaseCounters {
    public static void onHBaseRowCallback(String clientName, String tableName, String opName, String regionName, String serverName, long delta) {
        DatarouterHBaseCounters.onHBaseRowCallbackClientServer(clientName, serverName, delta);
        DatarouterHBaseCounters.onHBaseRowCallbackClientServerTable(clientName, tableName, serverName, delta);
        DatarouterHBaseCounters.onHBaseRowCallbackClientServerTableRegion(clientName, tableName, serverName, regionName, delta);
        DatarouterHBaseCounters.onHBaseRowCallbackClientServerTableOp(clientName, tableName, serverName, opName, delta);
        DatarouterHBaseCounters.onHBaseRowCallbackClientTableServer(clientName, tableName, serverName, delta);
        DatarouterHBaseCounters.onHBaseRowCallbackClientTableServerOp(clientName, tableName, serverName, opName, delta);
    }

    private static void onHBaseRowCallbackClientServer(String clientName, String serverName, long delta) {
        String key = String.valueOf(clientName) + " " + serverName;
        DatarouterHBaseCounters.onHBaseRowCallbackInternal("client-server", key, delta);
    }

    private static void onHBaseRowCallbackClientServerTable(String clientName, String tableName, String serverName, long delta) {
        String key = String.valueOf(clientName) + " " + serverName + " " + tableName;
        DatarouterHBaseCounters.onHBaseRowCallbackInternal("client-server-table", key, delta);
    }

    private static void onHBaseRowCallbackClientServerTableRegion(String clientName, String tableName, String serverName, String regionName, long delta) {
        String key = String.valueOf(clientName) + " " + serverName + " " + tableName + " " + regionName;
        DatarouterHBaseCounters.onHBaseRowCallbackInternal("client-server-table-region", key, delta);
    }

    private static void onHBaseRowCallbackClientServerTableOp(String clientName, String tableName, String serverName, String opName, long delta) {
        String key = String.valueOf(clientName) + " " + serverName + " " + tableName + " " + opName;
        DatarouterHBaseCounters.onHBaseRowCallbackInternal("client-server-table-op", key, delta);
    }

    private static void onHBaseRowCallbackClientTableServer(String clientName, String tableName, String serverName, long delta) {
        String key = String.valueOf(clientName) + " " + tableName + " " + serverName;
        DatarouterHBaseCounters.onHBaseRowCallbackInternal("client-table-server", key, delta);
    }

    private static void onHBaseRowCallbackClientTableServerOp(String clientName, String tableName, String serverName, String opName, long delta) {
        String key = String.valueOf(clientName) + " " + tableName + " " + serverName + " " + opName;
        DatarouterHBaseCounters.onHBaseRowCallbackInternal("client-table-server-op", key, delta);
    }

    private static void onHBaseRowCallbackInternal(String aggregationLevel, String key, long delta) {
        Counters.inc((String)("Datarouter " + aggregationLevel + " rows " + key), (long)delta);
    }
}

