/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.subentity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.callback.CountingBatchCallbackFactory;
import io.datarouter.client.hbase.config.DatarouterHBaseExecutors;
import io.datarouter.client.hbase.node.HBaseIncrement;
import io.datarouter.client.hbase.node.nonentity.HBaseNode;
import io.datarouter.client.hbase.node.subentity.HBaseSubEntityReaderNode;
import io.datarouter.client.hbase.util.HBaseConfigTool;
import io.datarouter.client.hbase.util.HBaseTableTool;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.entity.EntityTool;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.comparable.SignedByteField;
import io.datarouter.model.field.imp.comparable.SignedByteFieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.entity.PhysicalSubEntitySortedMapStorageNode;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.lang.ObjectTool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;

public class HBaseSubEntityNode<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends HBaseSubEntityReaderNode<EK, E, PK, D, F>
implements PhysicalSubEntitySortedMapStorageNode<EK, PK, D, F>,
HBaseIncrement<PK> {
    public static final byte[] FAM = HBaseNode.FAM;
    public static final SignedByteFieldKey DUMMY = HBaseNode.DUMMY_FIELD_KEY;
    private static final int DEFAULT_WRITE_BATCH_SIZE = 100;
    private final CountingBatchCallbackFactory.CountingBatchCallback<?> putMultiCallback;
    private final CountingBatchCallbackFactory.CountingBatchCallback<?> deleteAllCallback;
    private final CountingBatchCallbackFactory.CountingBatchCallback<?> deleteMultiCallback;
    private final ClientType<?, ?> clientType;

    public HBaseSubEntityNode(HBaseClientManager hBaseClientManager, CountingBatchCallbackFactory countingBatchCallbackFactory, EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params, ClientType<?, ?> clientType, DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor) {
        super(hBaseClientManager, entityNodeParams, params, clientType, datarouterHbaseClientExecutor);
        this.clientType = clientType;
        CountingBatchCallbackFactory countingBatchCallbackFactory2 = countingBatchCallbackFactory;
        countingBatchCallbackFactory2.getClass();
        this.putMultiCallback = new CountingBatchCallbackFactory.CountingBatchCallback(countingBatchCallbackFactory2, this, "putMulti");
        CountingBatchCallbackFactory countingBatchCallbackFactory3 = countingBatchCallbackFactory;
        countingBatchCallbackFactory3.getClass();
        this.deleteAllCallback = new CountingBatchCallbackFactory.CountingBatchCallback(countingBatchCallbackFactory3, this, "deleteAll");
        CountingBatchCallbackFactory countingBatchCallbackFactory4 = countingBatchCallbackFactory;
        countingBatchCallbackFactory4.getClass();
        this.deleteMultiCallback = new CountingBatchCallbackFactory.CountingBatchCallback(countingBatchCallbackFactory4, this, "deleteMulti");
    }

    public void put(D databean, Config config) {
        if (databean == null) {
            return;
        }
        this.putMulti(Collections.singletonList(databean), config);
    }

    /*
     * WARNING - void declaration
     */
    public void putMulti(Collection<D> databeans, Config config) {
        if (databeans == null || databeans.isEmpty()) {
            return;
        }
        String clientName = this.getClientId().getName();
        String nodeName = this.getName();
        Durability durability = HBaseConfigTool.getDurability(config);
        int batchSize = config.findInputBatchSize().orElse(100);
        for (List databeanBatch : Scanner.of(databeans).batch(batchSize).iterable()) {
            ArrayList<Object> actions = new ArrayList<Object>();
            int numCellsPut = 0;
            int putBytes = 0;
            int putValueBytes = 0;
            int numCellsDeleted = 0;
            int deleteBytes = 0;
            NavigableMap databeansByEntityKey = EntityTool.getDatabeansByEntityKey((Iterable)databeanBatch);
            for (Map.Entry entry : databeansByEntityKey.entrySet()) {
                byte[] ekBytes = this.queryBuilder.getRowBytesWithPartition((EntityKey)entry.getKey());
                Put put = new Put(ekBytes);
                Delete delete = new Delete(ekBytes);
                for (Databean databean : (List)entry.getValue()) {
                    EntityPrimaryKey pk = (EntityPrimaryKey)databean.getKey();
                    byte[] qualifierPkBytes = this.queryBuilder.getQualifierPkBytes(pk);
                    List fields = this.getFieldInfo().getNonKeyFieldsWithValues(databean);
                    boolean didAtLeastOneField = false;
                    for (Field field : fields) {
                        byte[] fullQualifierBytes = ByteTool.concatenate((byte[][])new byte[][]{this.getFieldInfo().getEntityColumnPrefixBytes(), qualifierPkBytes, field.getKey().getColumnNameBytes()});
                        byte[] fieldValueBytes = field.getBytes();
                        if (fieldValueBytes == null) {
                            boolean ignoreNulls = config.findIgnoreNullFields().orElse(false);
                            if (ignoreNulls) continue;
                            delete.addColumns(FAM, fullQualifierBytes);
                            deleteBytes += fullQualifierBytes.length;
                            ++numCellsDeleted;
                            continue;
                        }
                        didAtLeastOneField = true;
                        put.addColumn(FAM, fullQualifierBytes, fieldValueBytes);
                        putBytes += fullQualifierBytes.length;
                        putValueBytes += fieldValueBytes.length;
                        ++numCellsPut;
                    }
                    if (didAtLeastOneField) continue;
                    SignedByteField dummyField = new SignedByteField(DUMMY, Byte.valueOf((byte)0));
                    byte[] dummyQualifierBytes = ByteTool.concatenate((byte[][])new byte[][]{this.getFieldInfo().getEntityColumnPrefixBytes(), qualifierPkBytes, dummyField.getKey().getColumnNameBytes()});
                    byte[] dummyValueBytes = dummyField.getBytes();
                    put.addColumn(FAM, dummyQualifierBytes, dummyValueBytes);
                    putBytes += dummyQualifierBytes.length;
                    putValueBytes += dummyValueBytes.length;
                    ++numCellsPut;
                }
                if (!delete.isEmpty()) {
                    delete.setDurability(durability);
                    actions.add(delete);
                }
                put.setDurability(durability);
                actions.add(put);
            }
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells put", (String)clientName, (String)nodeName, (long)numCellsPut);
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"put", (String)clientName, (String)nodeName, (long)1L);
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells delete", (String)clientName, (String)nodeName, (long)numCellsDeleted);
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"delete", (String)clientName, (String)nodeName, (long)1L);
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"databeans put", (String)clientName, (String)nodeName, (long)databeanBatch.size());
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"entities put", (String)clientName, (String)nodeName, (long)databeansByEntityKey.size());
            if (actions.isEmpty()) continue;
            try {
                Throwable throwable = null;
                Iterator iterator = null;
                try {
                    Table table = this.getTable();
                    try {
                        try (TraceSpanFinisher $ = TracerTool.startSpan((String)"Table batchCallback", (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
                            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("actions", (Object)actions.size()).add("cellsPut", (Object)numCellsPut).add("putBytes", (Object)putBytes).add("putValueBytes", (Object)putValueBytes).add("cellsDeleted", (Object)numCellsDeleted).add("deleteBytes", (Object)deleteBytes));
                            table.batchCallback(actions, new Object[actions.size()], this.putMultiCallback);
                        }
                        if (table == null) continue;
                    }
                    catch (Throwable throwable2) {
                        void var16_21;
                        if (throwable == null) {
                            Throwable throwable3 = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (table != null) {
                            table.close();
                        }
                        throw var16_21;
                    }
                    table.close();
                }
                catch (Throwable throwable4) {
                    void var16_23;
                    if (throwable == null) {
                        Throwable throwable5 = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw var16_23;
                }
            }
            catch (IOException | InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void increment(Map<PK, Map<String, Long>> countByColumnByKey, Config config) {
        Durability durability = HBaseConfigTool.getDurability(config);
        ArrayList<Increment> actions = new ArrayList<Increment>();
        int cellCount = 0;
        int databeanCount = 0;
        NavigableMap keysByEntityKey = EntityTool.getPrimaryKeysByEntityKey(countByColumnByKey.keySet());
        for (Map.Entry entry : keysByEntityKey.entrySet()) {
            byte[] ekBytes = this.queryBuilder.getRowBytesWithPartition((EntityKey)entry.getKey());
            Increment increment = new Increment(ekBytes);
            for (EntityPrimaryKey key : (List)entry.getValue()) {
                byte[] qualifierPkBytes = this.queryBuilder.getQualifierPkBytes(key);
                for (Map.Entry<String, Long> entry2 : countByColumnByKey.get(key).entrySet()) {
                    this.assertColumnIsUInt63Field(entry2.getKey());
                    byte[] fullQualifierBytes = ByteTool.concatenate((byte[][])new byte[][]{this.getFieldInfo().getEntityColumnPrefixBytes(), qualifierPkBytes, StringByteTool.getUtf8Bytes((String)entry2.getKey())});
                    increment.addColumn(FAM, fullQualifierBytes, entry2.getValue().longValue());
                    ++cellCount;
                }
                ++databeanCount;
            }
            increment.setDurability(durability);
            actions.add(increment);
        }
        if (!actions.isEmpty()) {
            try {
                Throwable throwable = null;
                Iterator iterator = null;
                try (Table table = this.getTable();){
                    table.batch(actions, null);
                }
                catch (Throwable throwable2) {
                    void var8_14;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var8_14;
                }
            }
            catch (IOException | InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }
        TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().databeans((Number)databeanCount).add("cells", (Object)cellCount));
        String string = this.getClientId().getName();
        String nodeName = this.getName();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells incremented", (String)string, (String)nodeName, (long)cellCount);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"databeans incremented", (String)string, (String)nodeName, (long)databeanCount);
    }

    private void assertColumnIsUInt63Field(String columnName) {
        Field field = this.getFieldInfo().getFieldForColumnName(columnName);
        if (ObjectTool.notEquals(field.getClass(), UInt63Field.class)) {
            throw new IllegalArgumentException(String.valueOf(columnName) + " is a " + field.getClass() + ", but you can only increment a UInt63Field");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteAll(Config config) {
        Durability durability = HBaseConfigTool.getDurability(config);
        Scan scan = new Scan();
        scan.setFilter((Filter)new ColumnPrefixFilter(this.getFieldInfo().getEntityColumnPrefixBytes()));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Table table = this.getTable();
                try {
                    try (ResultScanner managedResultScanner = HBaseTableTool.getResultScanner(table, scan);){
                        Scanner.of((Iterable)managedResultScanner).exclude(Result::isEmpty).map(HBaseSubEntityNode::makeDelete).each(delete -> {
                            Delete delete2 = delete.setDurability(durability);
                        }).batch(100).forEach(batch -> {
                            try {
                                table.batchCallback(batch, new Object[batch.size()], this.deleteAllCallback);
                            }
                            catch (IOException | InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    if (table == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (table == null) throw throwable;
                    table.close();
                    throw throwable;
                }
                table.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Delete makeDelete(Result result) {
        Delete delete = new Delete(result.getRow());
        result.listCells().stream().forEach(cell -> {
            byte[] family = CellUtil.cloneFamily((Cell)cell);
            byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
            delete.addColumns(family, qualifier);
        });
        return delete;
    }

    public void delete(PK key, Config config) {
        if (key == null) {
            return;
        }
        this.deleteMulti(Collections.singletonList(key), config);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteMulti(Collection<PK> keys, Config config) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        Durability durability = HBaseConfigTool.getDurability(config);
        String clientName = this.getClientId().getName();
        String nodeName = this.getName();
        Set nonKeyColumnNames = this.getFieldInfo().getNonKeyFieldByColumnName().keySet();
        int batchSize = config.findInputBatchSize().orElse(100);
        for (List keyBatch : Scanner.of(keys).batch(batchSize).iterable()) {
            NavigableMap pksByEk = EntityTool.getPrimaryKeysByEntityKey((Iterable)keyBatch);
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (Map.Entry entry : pksByEk.entrySet()) {
                byte[] rowBytes = this.queryBuilder.getRowBytesWithPartition((EntityKey)entry.getKey());
                for (EntityPrimaryKey pk : (List)entry.getValue()) {
                    for (String columnName : nonKeyColumnNames) {
                        Delete delete = new Delete(rowBytes);
                        byte[] qualifier = this.queryBuilder.getQualifier(pk, columnName);
                        delete.addColumns(FAM, qualifier);
                        deletes.add(delete);
                    }
                    byte[] qualifierPkBytes = this.queryBuilder.getQualifierPkBytes(pk);
                    Delete delete = new Delete(rowBytes);
                    delete.setDurability(durability);
                    SignedByteField dummyField = new SignedByteField(DUMMY, Byte.valueOf((byte)0));
                    byte[] dummyQualifierBytes = ByteTool.concatenate((byte[][])new byte[][]{this.getFieldInfo().getEntityColumnPrefixBytes(), qualifierPkBytes, dummyField.getKey().getColumnNameBytes()});
                    delete.addColumns(FAM, dummyQualifierBytes);
                    deletes.add(delete);
                }
            }
            TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("databeans", (Object)keyBatch.size()).add("deletes", (Object)deletes.size()));
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells delete", (String)clientName, (String)nodeName, (long)deletes.size());
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"delete", (String)clientName, (String)nodeName, (long)1L);
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"databeans delete", (String)clientName, (String)nodeName, (long)keyBatch.size());
            DatarouterCounters.incClientNodeCustom(this.clientType, (String)"entities delete", (String)clientName, (String)nodeName, (long)pksByEk.size());
            try {
                Throwable throwable = null;
                Iterator iterator = null;
                try (Table table = this.getTable();){
                    table.batchCallback(deletes, new Object[deletes.size()], this.deleteMultiCallback);
                }
                catch (Throwable throwable2) {
                    void var12_17;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var12_17;
                }
            }
            catch (IOException | InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

