/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.entity;

import io.datarouter.model.entity.Entity;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.util.bytes.ByteTool;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;

public class HBaseEntityQueryBuilder<EK extends EntityKey<EK>, E extends Entity<EK>> {
    protected final EntityPartitioner<EK> partitioner;

    public HBaseEntityQueryBuilder(EntityFieldInfo<EK, E> entityFieldInfo) {
        this.partitioner = entityFieldInfo.getEntityPartitioner();
    }

    public byte[] getRowBytes(EK ek) {
        if (ek == null) {
            throw new IllegalArgumentException("no nulls");
        }
        return FieldTool.getConcatenatedValueBytesUnterminated((List)ek.getFields());
    }

    public byte[] getRowBytesWithPartition(EK ek) {
        byte[] partitionPrefix = this.partitioner.getPrefix(ek);
        return ByteTool.concatenate((byte[][])new byte[][]{partitionPrefix, this.getRowBytes(ek)});
    }

    public List<Scan> getScanForEachPartition(EK startKey, boolean startKeyInclusive) {
        byte[] ekBytesInclusive = new byte[]{};
        if (startKey != null) {
            byte[] ekBytes = this.getRowBytes(startKey);
            ekBytesInclusive = startKeyInclusive ? ekBytes : ByteTool.unsignedIncrement((byte[])ekBytes);
        }
        ArrayList<Scan> scans = new ArrayList<Scan>();
        int partition = 0;
        while (partition < this.partitioner.getNumPartitions()) {
            byte[] scanStartBytes = ByteTool.concatenate((byte[][])new byte[][]{this.partitioner.getPrefix(partition), ekBytesInclusive});
            FilterList filterList = new FilterList(new Filter[0]);
            filterList.addFilter((Filter)new PrefixFilter(this.partitioner.getPrefix(partition)));
            filterList.addFilter((Filter)new FirstKeyOnlyFilter());
            filterList.addFilter((Filter)new KeyOnlyFilter());
            Scan scan = new Scan().withStartRow(scanStartBytes).setFilter((Filter)filterList);
            scans.add(scan);
            ++partition;
        }
        return scans;
    }
}

