/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.nonentity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.lang.ReflectionTool;
import java.lang.reflect.Field;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.Result;

public class HBaseNonEntityResultParser<EK extends EntityKey<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final EntityPartitioner<EK> partitioner;
    private final DatabeanFieldInfo<PK, D, F> fieldInfo;

    public HBaseNonEntityResultParser(EntityPartitioner<EK> partitioner, DatabeanFieldInfo<PK, D, F> fieldInfo) {
        this.partitioner = partitioner;
        this.fieldInfo = fieldInfo;
    }

    public byte[] rowWithoutPrefix(byte[] rowWithPrefix) {
        int offset = this.partitioner.getNumPrefixBytes();
        int length = rowWithPrefix.length - offset;
        return ByteTool.copyOfRange((byte[])rowWithPrefix, (int)offset, (int)length);
    }

    public PK toPk(byte[] rowWithPrefix) {
        byte[] rowWithoutPrefix = this.rowWithoutPrefix(rowWithPrefix);
        EntityPrimaryKey primaryKey = (EntityPrimaryKey)this.fieldInfo.getPrimaryKeySupplier().get();
        if (ArrayTool.isEmpty((byte[])rowWithoutPrefix)) {
            return (PK)primaryKey;
        }
        int byteOffset = 0;
        for (io.datarouter.model.field.Field field : this.fieldInfo.getPrimaryKeyFields()) {
            int numBytesWithSeparator = field.numBytesWithSeparator(rowWithoutPrefix, byteOffset);
            Object value = field.fromBytesWithSeparatorButDoNotSet(rowWithoutPrefix, byteOffset);
            field.setUsingReflection((Object)primaryKey, value);
            byteOffset += numBytesWithSeparator;
        }
        return (PK)primaryKey;
    }

    public PK toPk(Result result) {
        return this.toPk(result.getRow());
    }

    public D toDatabean(Result result) {
        PK pk = this.toPk(result);
        Databean databean = (Databean)this.fieldInfo.getDatabeanSupplier().get();
        ReflectionTool.set((Field)this.fieldInfo.getKeyJavaField(), (Object)databean, pk);
        while (result.advance()) {
            io.datarouter.model.field.Field field;
            Cell cell = result.current();
            String qualifier = StringByteTool.fromUtf8Bytes((byte[])CellUtil.cloneQualifier((Cell)cell));
            if (HBaseClientManager.DUMMY_COL_NAME.equals(qualifier) || (field = this.fieldInfo.getFieldForColumnName(qualifier)) == null) continue;
            Object value = field.fromBytesButDoNotSet(CellUtil.cloneValue((Cell)cell), 0);
            field.setUsingReflection((Object)databean, value);
        }
        return (D)databean;
    }
}

