/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.nonentity;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.callback.CountingBatchCallbackFactory;
import io.datarouter.client.hbase.config.DatarouterHBaseExecutors;
import io.datarouter.client.hbase.node.HBaseIncrement;
import io.datarouter.client.hbase.node.nonentity.HBaseReaderNode;
import io.datarouter.client.hbase.util.HBaseConfigTool;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.exception.DataAccessException;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.comparable.SignedByteField;
import io.datarouter.model.field.imp.comparable.SignedByteFieldKey;
import io.datarouter.model.field.imp.positive.UInt63Field;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.util.DatarouterCounters;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.collection.CollectionTool;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.tuple.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;

public class HBaseNode<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends HBaseReaderNode<EK, E, PK, D, F>
implements SortedMapStorage.PhysicalSortedMapStorageNode<PK, D, F>,
HBaseIncrement<PK> {
    public static final byte[] FAM = HBaseClientManager.DEFAULT_FAMILY_QUALIFIER;
    public static final SignedByteFieldKey DUMMY_FIELD_KEY = new SignedByteFieldKey(HBaseClientManager.DUMMY_COL_NAME);
    private static final SignedByteField DUMMY_FIELD = new SignedByteField(DUMMY_FIELD_KEY, Byte.valueOf((byte)0));
    private final CountingBatchCallbackFactory.CountingBatchCallback<?> putMultiCallback;
    private final CountingBatchCallbackFactory.CountingBatchCallback<?> deleteMultiCallback;
    private final ClientType<?, ?> clientType;

    public HBaseNode(HBaseClientManager hBaseClientManager, ClientType<?, ?> clientType, CountingBatchCallbackFactory countingBatchCallbackFactory, DatarouterHBaseExecutors.DatarouterHbaseClientExecutor datarouterHbaseClientExecutor, EntityNodeParams<EK, E> entityNodeParams, NodeParams<PK, D, F> params) {
        super(hBaseClientManager, entityNodeParams, params, clientType, datarouterHbaseClientExecutor);
        this.clientType = clientType;
        CountingBatchCallbackFactory countingBatchCallbackFactory2 = countingBatchCallbackFactory;
        countingBatchCallbackFactory2.getClass();
        this.putMultiCallback = new CountingBatchCallbackFactory.CountingBatchCallback(countingBatchCallbackFactory2, this, "putMulti");
        CountingBatchCallbackFactory countingBatchCallbackFactory3 = countingBatchCallbackFactory;
        countingBatchCallbackFactory3.getClass();
        this.deleteMultiCallback = new CountingBatchCallbackFactory.CountingBatchCallback(countingBatchCallbackFactory3, this, "deleteMulti");
    }

    public void put(D databean, Config config) {
        this.putMulti(Collections.singletonList(databean), config);
    }

    public void putMulti(Collection<D> databeans, Config config) {
        if (databeans == null || databeans.isEmpty()) {
            return;
        }
        Durability durability = HBaseConfigTool.getDurability(config);
        boolean ignoreNulls = config.optIgnoreNullFields().orElse(false);
        int batchSize = config.optInputBatchSize().orElse(100);
        Scanner.of(databeans).include(Objects::nonNull).map(databean -> this.makePutAndDelete(databean, ignoreNulls, durability)).batch(batchSize).map(ActionBatch::new).forEach(batch -> {
            Throwable throwable = null;
            Object var3_4 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)"Table batchCallback");){
                this.traceAndCount(batch.actions.size(), batch.numCellsPut, batch.numCellsDeleted, batch.putBytes, batch.putValueBytes, batch.deleteBytes);
                this.execute(batch.actions, this.putMultiCallback);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
    }

    private PutAndDelete makePutAndDelete(D databean, boolean ignoreNulls, Durability durability) {
        byte[] keyBytesWithPrefix = this.queryBuilder.getPkBytesWithPartition((EntityPrimaryKey)databean.getKey());
        Put put = new Put(keyBytesWithPrefix).setDurability(durability);
        Delete delete = new Delete(keyBytesWithPrefix).setDurability(durability);
        int numCellsPut = 0;
        int numCellsDeleted = 0;
        int putBytes = 0;
        int putValueBytes = 0;
        int deleteBytes = 0;
        for (Field field : this.getFieldInfo().getNonKeyFieldsWithValues(databean)) {
            byte[] columnNameBytes = field.getKey().getColumnNameBytes();
            byte[] valueBytes = field.getBytes();
            if (valueBytes == null) {
                if (ignoreNulls) continue;
                delete.addColumns(FAM, columnNameBytes);
                deleteBytes += columnNameBytes.length;
                ++numCellsDeleted;
                continue;
            }
            put.addColumn(FAM, columnNameBytes, valueBytes);
            putBytes += columnNameBytes.length;
            putValueBytes += valueBytes.length;
            ++numCellsPut;
        }
        if (put.isEmpty()) {
            byte[] columnNameBytes = DUMMY_FIELD_KEY.getColumnNameBytes();
            byte[] valueBytes = DUMMY_FIELD.getBytes();
            put.addColumn(FAM, columnNameBytes, valueBytes);
            putBytes += columnNameBytes.length;
            putValueBytes += valueBytes.length;
            ++numCellsPut;
        }
        return new PutAndDelete(put, delete, numCellsPut, numCellsDeleted, putBytes, putValueBytes, deleteBytes);
    }

    private void traceAndCount(int numActions, int numCellsPut, int numCellsDeleted, int putBytes, int putValueBytes, int deleteBytes) {
        TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("actions", (Object)numActions).add("cellsPut", (Object)numCellsPut).add("cellsDeleted", (Object)numCellsDeleted).add("putBytes", (Object)putBytes).add("putValueBytes", (Object)putValueBytes).add("deleteBytes", (Object)deleteBytes));
        String clientName = this.clientTableNodeNames.getClientName();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells put", (String)clientName, (String)this.getName(), (long)numCellsPut);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells delete", (String)clientName, (String)this.getName(), (long)numCellsDeleted);
    }

    public void deleteAll(Config config) {
        Durability durability = HBaseConfigTool.getDurability(config);
        this.scanResults(Range.everything(), config, true).map(Result::getRow).map(Delete::new).map(delete -> delete.setDurability(durability)).batch(config.optInputBatchSize().orElse(100).intValue()).forEach(actions -> this.execute((List<? extends Row>)actions, this.deleteMultiCallback));
    }

    public void delete(PK key, Config config) {
        this.deleteMulti(Collections.singletonList(key), config);
    }

    public void deleteMulti(Collection<PK> keys, Config config) {
        Durability durability = HBaseConfigTool.getDurability(config);
        Scanner.of(keys).map(this.queryBuilder::getPkBytesWithPartition).map(Delete::new).map(delete -> delete.setDurability(durability)).batch(config.optInputBatchSize().orElse(100).intValue()).forEach(deletes -> {
            TracerTool.appendToSpanInfo((String)"databeans", (Object)deletes.size());
            this.execute((List<? extends Row>)deletes, this.deleteMultiCallback);
        });
    }

    @Override
    public void increment(Map<PK, Map<String, Long>> countByColumnByKey, Config config) {
        Object keyBytesWithPrefix;
        if (countByColumnByKey == null) {
            return;
        }
        Durability durability = HBaseConfigTool.getDurability(config);
        ArrayList<Increment> actions = new ArrayList<Increment>();
        int cellCount = 0;
        int databeanCount = 0;
        for (Map.Entry<PK, Map<String, Long>> row : countByColumnByKey.entrySet()) {
            keyBytesWithPrefix = this.queryBuilder.getPkBytesWithPartition((EntityPrimaryKey)row.getKey());
            Increment increment = new Increment((byte[])keyBytesWithPrefix);
            for (Map.Entry<String, Long> columnCount : row.getValue().entrySet()) {
                String columnName = columnCount.getKey();
                this.assertColumnIsUInt63Field(columnName);
                byte[] columnNameBytes = StringByteTool.getUtf8Bytes((String)columnName);
                increment.addColumn(FAM, columnNameBytes, columnCount.getValue().longValue());
                ++cellCount;
            }
            increment.setDurability(durability);
            actions.add(increment);
            ++databeanCount;
        }
        TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("databeans", (Object)databeanCount).add("cells", (Object)cellCount));
        String clientName = this.getClientId().getName();
        String nodeName = this.getName();
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"cells incremented", (String)clientName, (String)nodeName, (long)cellCount);
        DatarouterCounters.incClientNodeCustom(this.clientType, (String)"databeans incremented", (String)clientName, (String)nodeName, (long)databeanCount);
        if (CollectionTool.nullSafeNotEmpty(actions)) {
            try {
                keyBytesWithPrefix = null;
                Object var10_12 = null;
                try (Table table = this.getTable();){
                    table.batch(actions, null);
                }
                catch (Throwable throwable) {
                    if (keyBytesWithPrefix == null) {
                        keyBytesWithPrefix = throwable;
                    } else if (keyBytesWithPrefix != throwable) {
                        ((Throwable)keyBytesWithPrefix).addSuppressed(throwable);
                    }
                    throw keyBytesWithPrefix;
                }
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void execute(List<? extends Row> actions, CountingBatchCallbackFactory.CountingBatchCallback<?> callback) {
        if (actions.isEmpty()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Table table = this.getTable();){
                table.batchCallback(actions, new Object[actions.size()], callback);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private void assertColumnIsUInt63Field(String columnName) {
        Field field = this.getFieldInfo().getFieldForColumnName(columnName);
        if (ObjectTool.notEquals(field.getClass(), UInt63Field.class)) {
            throw new IllegalArgumentException(String.valueOf(columnName) + " is a " + field.getClass() + ", but you can only increment a UInt63Field");
        }
    }

    private static class ActionBatch {
        public final List<Row> actions = new ArrayList<Row>();
        public int numCellsPut = 0;
        public int numCellsDeleted = 0;
        public int putBytes = 0;
        public int putValueBytes = 0;
        public int deleteBytes = 0;

        public ActionBatch(List<PutAndDelete> putAndDeletes) {
            for (PutAndDelete putAndDelete : putAndDeletes) {
                this.actions.add((Row)putAndDelete.put);
                if (!putAndDelete.delete.isEmpty()) {
                    this.actions.add((Row)putAndDelete.delete);
                }
                this.numCellsPut += putAndDelete.numCellsPut;
                this.numCellsDeleted += putAndDelete.numCellsDeleted;
                this.putBytes += putAndDelete.putBytes;
                this.putValueBytes += putAndDelete.putValueBytes;
                this.deleteBytes += putAndDelete.deleteBytes;
            }
        }
    }

    private static class PutAndDelete {
        public final Put put;
        public final Delete delete;
        public final int numCellsPut;
        public final int numCellsDeleted;
        public final int putBytes;
        public final int putValueBytes;
        public final int deleteBytes;

        public PutAndDelete(Put put, Delete delete, int numCellsPut, int numCellsDeleted, int putBytes, int putValueBytes, int deleteBytes) {
            this.put = put;
            this.delete = delete;
            this.numCellsPut = numCellsPut;
            this.numCellsDeleted = numCellsDeleted;
            this.putBytes = putBytes;
            this.putValueBytes = putValueBytes;
            this.deleteBytes = deleteBytes;
        }
    }
}

