/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;

public class DrTableSettings {
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String COMPRESSION = "COMPRESSION";
    public static final String DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING";
    public static final String ENCODE_ON_DISK = "ENCODE_ON_DISK";
    public static final String IN_MEMORY = "IN_MEMORY";
    public static final String TTL = "TTL";
    public static final String VERSIONS = "VERSIONS";
    public static final SortedSet<String> COLUMN_SETTINGS = new TreeSet<String>();
    public static final List<String> BLOOMFILTER_STRINGS;
    public static final List<String> COMPRESSION_STRINGS;
    public static final List<String> DATA_BLOCK_ENCODING_STRINGS;
    public static final String DEFAULT_DATA_BLOCK_ENCODING = "NONE";
    public static final String DEFAULT_ENCODE_ON_DISK = "true";

    static {
        COLUMN_SETTINGS.add(BLOCKCACHE);
        COLUMN_SETTINGS.add(BLOCKSIZE);
        COLUMN_SETTINGS.add(BLOOMFILTER);
        COLUMN_SETTINGS.add(COMPRESSION);
        COLUMN_SETTINGS.add(DATA_BLOCK_ENCODING);
        COLUMN_SETTINGS.add(ENCODE_ON_DISK);
        COLUMN_SETTINGS.add(IN_MEMORY);
        COLUMN_SETTINGS.add(TTL);
        COLUMN_SETTINGS.add(VERSIONS);
        BLOOMFILTER_STRINGS = Arrays.asList(DEFAULT_DATA_BLOCK_ENCODING, "ROW", "ROWCOL");
        COMPRESSION_STRINGS = Arrays.stream(Compression.Algorithm.values()).map(Enum::toString).collect(Collectors.toList());
        DATA_BLOCK_ENCODING_STRINGS = Arrays.stream(DataBlockEncoding.values()).map(Enum::toString).collect(Collectors.toList());
    }

    public static void validateColumnFamilySetting(String setting, String value) {
        if (BLOCKCACHE.equals(setting)) {
            if (!DrTableSettings.validBoolean(value)) {
                throw new IllegalArgumentException("invalid BLOCKCACHE");
            }
        } else if (BLOCKSIZE.equals(setting)) {
            Long.valueOf(value);
        } else if (BLOOMFILTER.equals(setting)) {
            if (!BLOOMFILTER_STRINGS.contains(value)) {
                throw new IllegalArgumentException("invalid BLOOMFILTER " + value);
            }
        } else if (COMPRESSION.equals(setting)) {
            if (!COMPRESSION_STRINGS.contains(value)) {
                throw new IllegalArgumentException("invalid COMPRESSION " + value);
            }
        } else if (DATA_BLOCK_ENCODING.equals(setting)) {
            if (!DATA_BLOCK_ENCODING_STRINGS.contains(value)) {
                throw new IllegalArgumentException("invalid DATA_BLOCK_ENCODING " + value);
            }
        } else if (ENCODE_ON_DISK.equals(setting)) {
            if (!DrTableSettings.validBoolean(value)) {
                throw new IllegalArgumentException("invalid ENCODE_ON_DISK");
            }
        } else if (IN_MEMORY.equals(setting)) {
            if (!DrTableSettings.validBoolean(value)) {
                throw new IllegalArgumentException("invalid IN_MEMORY");
            }
        } else if (TTL.equals(setting)) {
            Long.valueOf(value);
        } else if (VERSIONS.equals(setting)) {
            Integer.valueOf(value);
        } else {
            throw new IllegalArgumentException("unknown setting " + setting);
        }
    }

    protected static boolean validBoolean(String value) {
        return "TRUE".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value);
    }
}

