/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.client.HBaseConnectionHolder;
import io.datarouter.client.hbase.util.HBaseClientTool;
import io.datarouter.httpclient.path.PathNode;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.model.serialize.fielder.TtlFielderConfig;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.executor.DatarouterStorageExecutors;
import io.datarouter.storage.config.schema.BaseSchemaUpdateService;
import io.datarouter.storage.config.schema.SchemaUpdateOptions;
import io.datarouter.storage.config.schema.SchemaUpdateResult;
import io.datarouter.storage.config.schema.SchemaUpdateTool;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.web.config.DatarouterWebPaths;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import j2html.TagCreator;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HBaseSchemaUpdateService
extends BaseSchemaUpdateService {
    private static final Logger logger = LoggerFactory.getLogger(HBaseSchemaUpdateService.class);
    private static final long DEFAULT_MAX_FILE_SIZE_BYTES = 0x100000000L;
    private static final long DEFAULT_MEMSTORE_FLUSH_SIZE_BYTES = 0x10000000L;
    private static final int MAX_VERSIONS = 1;
    private final DatarouterHtmlEmailService htmlEmailService;
    private final HBaseConnectionHolder hBaseConnectionHolder;
    private final SchemaUpdateOptions schemaUpdateOptions;
    private final DatarouterWebPaths datarouterWebPaths;

    @Inject
    public HBaseSchemaUpdateService(DatarouterProperties datarouterProperties, DatarouterAdministratorEmailService adminEmailService, DatarouterStorageExecutors.DatarouterSchemaUpdateScheduler executor, DatarouterHtmlEmailService htmlEmailService, HBaseConnectionHolder hBaseConnectionHolder, SchemaUpdateOptions schemaUpdateOptions, DatarouterWebPaths datarouterWebPaths) {
        super(datarouterProperties, adminEmailService, executor);
        this.htmlEmailService = htmlEmailService;
        this.hBaseConnectionHolder = hBaseConnectionHolder;
        this.schemaUpdateOptions = schemaUpdateOptions;
        this.datarouterWebPaths = datarouterWebPaths;
    }

    protected Callable<Optional<SchemaUpdateResult>> makeSchemaUpdateCallable(ClientId clientId, Supplier<List<String>> existingTableNames, PhysicalNode<?, ?, ?> node) {
        return () -> this.generateSchemaUpdate(clientId, existingTableNames, node);
    }

    protected void sendEmail(String fromEmail, String toEmail, String subject, String body) {
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath((PathNode)this.datarouterWebPaths.datarouter).build();
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(subject).withTitle("HBase Schema Update").withTitleHref(primaryHref).withContent(TagCreator.pre((String)body));
        this.htmlEmailService.trySendJ2Html(fromEmail, toEmail, emailBuilder);
    }

    protected List<String> fetchExistingTables(ClientId clientId) {
        TableName[] tableNames;
        try {
            tableNames = this.hBaseConnectionHolder.getConnection(clientId).getAdmin().listTableNames();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Arrays.stream(tableNames).map(TableName::getNameAsString).collect(Collectors.toList());
    }

    private Optional<SchemaUpdateResult> generateSchemaUpdate(ClientId clientId, Supplier<List<String>> existingTableNames, PhysicalNode<?, ?, ?> node) throws IOException {
        PhysicalDatabeanFieldInfo fieldInfo = node.getFieldInfo();
        TableName tableName = TableName.valueOf((String)fieldInfo.getTableName());
        if (!existingTableNames.get().contains(tableName.getNameAsString())) {
            this.createTable(clientId, node);
            return Optional.empty();
        }
        Admin admin = this.hBaseConnectionHolder.getConnection(clientId).getAdmin();
        HTableDescriptor desc = admin.getTableDescriptor(tableName);
        int requestedTtlSeconds = fieldInfo.getSampleFielder().getOption(TtlFielderConfig.KEY).map(TtlFielderConfig::getTtl).map(Duration::getSeconds).map(Math::toIntExact).orElse(Integer.MAX_VALUE);
        ArrayList<String> ddls = new ArrayList<String>();
        HColumnDescriptor[] hColumnDescriptorArray = desc.getColumnFamilies();
        int n = hColumnDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ddl;
            HColumnDescriptor column = hColumnDescriptorArray[n2];
            if (requestedTtlSeconds != column.getTimeToLive()) {
                ddl = "alter '" + tableName + "', NAME => '" + column.getNameAsString() + "', TTL => " + requestedTtlSeconds;
                if (this.schemaUpdateOptions.getModifyTtl(false)) {
                    logger.warn(SchemaUpdateTool.generateFullWidthMessage((String)"Executing SchemaUpdate"));
                    logger.warn(ddl);
                    column.setTimeToLive(requestedTtlSeconds);
                    admin.modifyColumn(tableName, column);
                } else if (this.schemaUpdateOptions.getModifyTtl(true)) {
                    logger.warn(SchemaUpdateTool.generateFullWidthMessage((String)"Please Execute SchemaUpdate"));
                    logger.warn(ddl);
                    ddls.add(ddl);
                }
            }
            if (1 != column.getMaxVersions()) {
                ddl = "alter '" + tableName + "', NAME => '" + column.getNameAsString() + "', VERSIONS => " + 1;
                if (this.schemaUpdateOptions.getModifyMaxVersions(false)) {
                    logger.warn(SchemaUpdateTool.generateFullWidthMessage((String)"Executing SchemaUpdate"));
                    logger.warn(ddl);
                    column.setMaxVersions(1);
                    admin.modifyColumn(tableName, column);
                } else if (this.schemaUpdateOptions.getModifyMaxVersions(true)) {
                    logger.warn(SchemaUpdateTool.generateFullWidthMessage((String)"Please Execute SchemaUpdate"));
                    logger.warn(ddl);
                    ddls.add(ddl);
                }
            }
            ++n2;
        }
        if (ddls.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new SchemaUpdateResult(String.join((CharSequence)"\n", ddls), null, clientId));
    }

    private void createTable(ClientId clientId, PhysicalNode<?, ?, ?> node) throws IOException {
        String tableName = node.getFieldInfo().getTableName();
        if (this.schemaUpdateOptions.getCreateTables(false).booleanValue()) {
            logger.warn("table " + tableName + " not found, creating it");
            try {
                HTableDescriptor htable = new HTableDescriptor(TableName.valueOf((String)tableName));
                htable.setMaxFileSize(0x100000000L);
                htable.setMemStoreFlushSize(0x10000000L);
                HColumnDescriptor family = new HColumnDescriptor(HBaseClientManager.DEFAULT_FAMILY_QUALIFIER);
                PhysicalDatabeanFieldInfo fieldInfo = node.getFieldInfo();
                DatabeanFielder fielder = fieldInfo.getSampleFielder();
                family.setMaxVersions(1);
                family.setBloomFilterType(BloomType.NONE);
                family.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
                family.setCompressionType(Compression.Algorithm.GZ);
                int ttlSeconds = fielder.getOption(TtlFielderConfig.KEY).map(TtlFielderConfig::getTtl).map(Duration::getSeconds).map(Math::toIntExact).orElse(Integer.MAX_VALUE);
                family.setTimeToLive(ttlSeconds);
                htable.addFamily(family);
                byte[][] splitPoints = HBaseClientTool.getSplitPoints(node);
                Admin admin = this.hBaseConnectionHolder.getConnection(clientId).getAdmin();
                if (ArrayTool.isEmpty((Object[])splitPoints) || ArrayTool.isEmpty((byte[])splitPoints[0])) {
                    admin.createTable(htable);
                } else {
                    admin.createTable(htable, splitPoints);
                }
                logger.warn("created table " + tableName);
            }
            catch (TableExistsException e) {
                logger.warn("table " + tableName + " already created by another process");
            }
        } else if (this.schemaUpdateOptions.getCreateTables(true).booleanValue()) {
            logger.warn("table " + tableName + " not found");
        }
    }
}

