/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.node.subentity;

import io.datarouter.client.hbase.node.entity.HBaseEntityQueryBuilder;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.field.FieldTool;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.collection.ListTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;

public class HBaseSubEntityQueryBuilder<EK extends EntityKey<EK>, E extends Entity<EK>, PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends HBaseEntityQueryBuilder<EK, E> {
    public static final int BATCH_SIZE = 100;
    private final PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo;

    public HBaseSubEntityQueryBuilder(EntityFieldInfo<EK, E> entityFieldInfo, PhysicalDatabeanFieldInfo<PK, D, F> fieldInfo) {
        super(entityFieldInfo);
        this.fieldInfo = fieldInfo;
    }

    public byte[] getQualifier(PK primaryKey, String fieldName) {
        return ByteTool.concatenate((byte[][])new byte[][]{this.fieldInfo.getEntityColumnPrefixBytes(), this.getQualifierPkBytes(primaryKey, true), StringByteTool.getUtf8Bytes((String)fieldName)});
    }

    private byte[] getQualifierPrefix(PK primaryKey) {
        return ByteTool.concatenate((byte[][])new byte[][]{this.fieldInfo.getEntityColumnPrefixBytes(), this.getQualifierPkBytes(primaryKey, true)});
    }

    public byte[] getQualifierPkBytes(PK primaryKey, boolean trailingSeparatorAfterEndingString) {
        if (primaryKey == null) {
            return new byte[0];
        }
        return FieldTool.getConcatenatedValueBytes((Collection)primaryKey.getPostEntityKeyFields(), (boolean)true, (boolean)trailingSeparatorAfterEndingString, (boolean)trailingSeparatorAfterEndingString);
    }

    public List<Get> getGets(Collection<PK> pks, boolean keysOnly) {
        ArrayList gets = ListTool.createArrayListWithSize(pks);
        for (EntityPrimaryKey pk : pks) {
            byte[] rowBytes = this.getRowBytesWithPartition(pk.getEntityKey());
            byte[] qualifierPrefix = this.getQualifierPrefix(pk);
            Get get = new Get(rowBytes);
            if (keysOnly) {
                FilterList filters = new FilterList(new Filter[0]);
                filters.addFilter((Filter)new KeyOnlyFilter());
                filters.addFilter((Filter)new ColumnPrefixFilter(qualifierPrefix));
                get.setFilter((Filter)filters);
            } else {
                get.setFilter((Filter)new ColumnPrefixFilter(qualifierPrefix));
            }
            gets.add(get);
        }
        return gets;
    }
}

