/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.util.bytes.ByteRange;
import io.datarouter.util.bytes.ByteTool;
import io.datarouter.util.bytes.StringByteTool;
import io.datarouter.util.tuple.Range;
import java.util.Optional;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.PageFilter;

public class HBaseScanBuilder {
    private static final byte[] EMPTY_PREFIX = new byte[0];
    private static final KeyOnlyFilter KEY_ONLY_FILTER = new KeyOnlyFilter();
    private static final FirstKeyOnlyFilter FIRST_KEY_ONLY_FILTER = new FirstKeyOnlyFilter();
    private byte[] prefix = EMPTY_PREFIX;
    private Range<ByteRange> range = Range.everything();
    private Filter columnPrefixFilter;
    private Integer limit;
    private Filter keyFilter;
    private boolean cacheBlocks = true;

    public HBaseScanBuilder withPrefix(byte[] prefix) {
        this.prefix = prefix;
        return this;
    }

    public HBaseScanBuilder withRange(Range<ByteRange> range) {
        this.range = range;
        return this;
    }

    public HBaseScanBuilder withColumnPrefix(String columnPrefix) {
        this.columnPrefixFilter = new ColumnPrefixFilter(StringByteTool.getUtf8Bytes((String)columnPrefix));
        return this;
    }

    public HBaseScanBuilder withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public HBaseScanBuilder withKeyOnly(boolean keyOnly) {
        if (keyOnly) {
            this.keyFilter = KEY_ONLY_FILTER;
        }
        return this;
    }

    public HBaseScanBuilder withFirstKeyOnly(boolean firstKeyOnly) {
        if (firstKeyOnly) {
            this.keyFilter = FIRST_KEY_ONLY_FILTER;
        }
        return this;
    }

    public HBaseScanBuilder withCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public Scan build() {
        Scan scan = this.getScanForRange();
        scan.setCacheBlocks(this.cacheBlocks);
        this.makeFilter().ifPresent(arg_0 -> ((Scan)scan).setFilter(arg_0));
        return scan;
    }

    private Scan getScanForRange() {
        byte[] startWithPrefix = ByteTool.concatenate((byte[][])new byte[][]{this.prefix, this.getStartInclusive()});
        byte[] endWithoutPrefix = this.getEndExclusive();
        if (this.prefix.length == 0) {
            if (endWithoutPrefix.length == 0) {
                return new Scan(startWithPrefix);
            }
            return new Scan(startWithPrefix, endWithoutPrefix);
        }
        if (endWithoutPrefix.length == 0) {
            return new Scan(startWithPrefix, ByteTool.unsignedIncrement((byte[])this.prefix));
        }
        return new Scan(startWithPrefix, ByteTool.concatenate((byte[][])new byte[][]{this.prefix, endWithoutPrefix}));
    }

    private Optional<Filter> makeFilter() {
        FilterList filterList = new FilterList(new Filter[0]);
        if (this.columnPrefixFilter != null) {
            filterList.addFilter(this.columnPrefixFilter);
        }
        if (this.keyFilter != null) {
            filterList.addFilter(this.keyFilter);
        }
        if (this.limit != null) {
            filterList.addFilter((Filter)new PageFilter((long)this.limit.intValue()));
        }
        if (filterList.getFilters().isEmpty()) {
            return Optional.empty();
        }
        if (filterList.getFilters().size() == 1) {
            return Optional.of((Filter)filterList.getFilters().get(0));
        }
        return Optional.of(filterList);
    }

    private byte[] getStartInclusive() {
        if (!this.range.hasStart()) {
            return new byte[0];
        }
        if (this.range.getStartInclusive()) {
            return ((ByteRange)this.range.getStart()).toArray();
        }
        return ((ByteRange)this.range.getStart()).copyToArrayNewArrayAndIncrement();
    }

    private byte[] getEndExclusive() {
        if (!this.range.hasEnd()) {
            return new byte[0];
        }
        if (this.range.getEndInclusive()) {
            return ((ByteRange)this.range.getEnd()).copyToArrayNewArrayAndIncrement();
        }
        return ((ByteRange)this.range.getEnd()).toArray();
    }
}

