/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.web;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.config.DatarouterHBaseFiles;
import io.datarouter.client.hbase.config.DatarouterHBasePaths;
import io.datarouter.pathnode.PathNode;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.web.browse.DatarouterClientWebInspector;
import io.datarouter.web.browse.dto.DatarouterWebRequestParamsFactory;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.params.Params;
import j2html.tags.specialized.DivTag;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;

@Singleton
public class HBaseWebInspector
implements DatarouterClientWebInspector {
    @Inject
    private ClientOptions clientOptions;
    @Inject
    private DatarouterHBaseFiles files;
    @Inject
    private DatarouterHBasePaths datarouterHBasePaths;
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private DatarouterWebRequestParamsFactory paramsFactory;
    @Inject
    private HBaseClientManager hBaseClientManager;

    public Mav inspectClient(Params params, HttpServletRequest request) {
        List<HTableDescriptor> tables;
        DatarouterWebRequestParamsFactory datarouterWebRequestParamsFactory = this.paramsFactory;
        datarouterWebRequestParamsFactory.getClass();
        DatarouterWebRequestParamsFactory.DatarouterWebRequestParams clientParams = new DatarouterWebRequestParamsFactory.DatarouterWebRequestParams(datarouterWebRequestParamsFactory, params, ClientType.class);
        ClientId clientId = clientParams.getClientId();
        if (clientId == null) {
            return new MessageMav("Client not found");
        }
        String clientName = clientId.getName();
        Map allClientOptions = this.clientOptions.getAllClientOptions(clientName);
        DivTag clientPageHeader = this.buildClientPageHeader(clientName);
        DivTag clientOptionsTable = this.buildClientOptionsTable(allClientOptions);
        Mav mav = new Mav();
        mav.setViewName(this.files.jsp.admin.datarouter.hbase.hbaseClientSummaryJsp);
        mav.put("clientPageHeader", (Object)clientPageHeader.render());
        mav.put("clientOptionsTable", (Object)clientOptionsTable.render());
        mav.put("address", (Object)this.hBaseClientManager.getConnection(clientId).getConfiguration().get("hbase.zookeeper.quorum"));
        try {
            tables = List.of(this.hBaseClientManager.getAdmin(clientId).listTables());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        TreeMap tableSummaryByName = new TreeMap();
        TreeMap<String, Map<String, Map<String, String>>> familySummaryByTableName = new TreeMap<String, Map<String, Map<String, String>>>();
        List tableNamesForClient = this.datarouterNodes.getTableNamesForClient(clientName);
        for (HTableDescriptor table : tables) {
            String tableName = table.getNameAsString();
            if (!tableNamesForClient.contains(tableName)) continue;
            TreeMap<String, String> tableAttributeByName = new TreeMap<String, String>();
            tableAttributeByName.put("maxFileSize", String.valueOf(table.getMaxFileSize()));
            tableAttributeByName.put("memStoreFlushSize", String.valueOf(table.getMemStoreFlushSize()));
            tableAttributeByName.put("readOnly", String.valueOf(table.isReadOnly()));
            tableSummaryByName.put(tableName, tableAttributeByName);
            Map<String, Map<String, String>> familyAttributeByNameByFamilyName = HBaseWebInspector.parseTableAttributeMap(table.getFamilies());
            familySummaryByTableName.put(table.getNameAsString(), familyAttributeByNameByFamilyName);
        }
        mav.put("tableSummaryByName", tableSummaryByName);
        mav.put("familySummaryByTableName", familySummaryByTableName);
        mav.put("clientType", (Object)clientParams.getClientType().getName());
        mav.put("hbaseHandlerPath", (Object)this.getHandlerPath().toSlashedString());
        return mav;
    }

    protected PathNode getHandlerPath() {
        return this.datarouterHBasePaths.datarouter.clients.hbase;
    }

    private static Map<String, Map<String, String>> parseTableAttributeMap(Collection<HColumnDescriptor> families) {
        TreeMap<String, Map<String, String>> familyAttributeByNameByFamilyName = new TreeMap<String, Map<String, String>>();
        for (HColumnDescriptor family : families) {
            TreeMap<String, String> familyAttributeByName = new TreeMap<String, String>();
            familyAttributeByNameByFamilyName.put(family.getNameAsString(), familyAttributeByName);
            for (Map.Entry e : family.getValues().entrySet()) {
                String key = Bytes.toString((byte[])((Bytes)e.getKey()).get());
                String value = Bytes.toString((byte[])((Bytes)e.getValue()).get());
                familyAttributeByName.put(key, value);
            }
        }
        return familyAttributeByNameByFamilyName;
    }
}

