/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.gson.serialization.GsonTool;
import io.datarouter.instrumentation.trace.TraceSpanFinisher;
import io.datarouter.instrumentation.trace.TraceSpanGroupType;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.model.exception.DataAccessException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseTableTool {
    public static Result[] getUnchecked(Table table, List<Get> gets) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)(table.getName() + " get"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
                TracerTool.appendToSpanInfo((String)"gets", (Object)gets.size());
                Result[] results = table.get(gets);
                TracerTool.appendToSpanInfo((String)"results", (Object)results.length);
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public static void deleteUnchecked(Table table, List<Delete> deletes) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)(table.getName() + " delete"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
                TracerTool.appendToSpanInfo((String)"deletes", (Object)deletes.size());
                table.delete(deletes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public static ResultScanner getResultScanner(Table table, Scan scan) throws IOException {
        String start = Bytes.toStringBinary((byte[])scan.getStartRow());
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TraceSpanFinisher $ = TracerTool.startSpan((String)(table.getName() + " getScanner"), (TraceSpanGroupType)TraceSpanGroupType.DATABASE);){
                TracerTool.appendToSpanInfo((String)"start", (Object)start);
                return table.getScanner(scan);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IOException("start=" + start + " stop=" + Bytes.toStringBinary((byte[])scan.getStopRow()) + " scan=" + GsonTool.GSON.toJson((Object)scan), e);
        }
    }
}

