/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import io.datarouter.client.hbase.node.nonentity.HBaseReaderNode;
import io.datarouter.model.key.entity.EntityPartitioner;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;

public class HBaseClientTool {
    public static byte[][] getSplitPoints(PhysicalNode<?, ?, ?> node) {
        EntityFieldInfo<?, ?> entityFieldInfo = HBaseClientTool.getEntityFieldInfo(node);
        EntityPartitioner partitioner = entityFieldInfo.getEntityPartitioner();
        int numSplitPoints = partitioner.getNumPartitions() - 1;
        byte[][] splitPoints = new byte[numSplitPoints][];
        int i = 1;
        while (i < partitioner.getAllPrefixes().size()) {
            splitPoints[i - 1] = partitioner.getPrefix(i);
            ++i;
        }
        return splitPoints;
    }

    public static EntityFieldInfo<?, ?> getEntityFieldInfo(Node<?, ?, ?> node) {
        PhysicalNode physicalNode = NodeTool.extractSinglePhysicalNode(node);
        HBaseReaderNode nonEntityNode = (HBaseReaderNode)physicalNode;
        return nonEntityNode.getEntityFieldInfo();
    }
}

