/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.util;

import java.util.Comparator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseResultComparator
implements Comparator<Result> {
    private final int numPrefixBytesToIgnore;

    public HBaseResultComparator(int numPrefixBytes) {
        this.numPrefixBytesToIgnore = numPrefixBytes;
    }

    @Override
    public int compare(Result left, Result right) {
        int leftLength = left.getRow().length - this.numPrefixBytesToIgnore;
        int rightLength = right.getRow().length - this.numPrefixBytesToIgnore;
        return Bytes.compareTo((byte[])left.getRow(), (int)this.numPrefixBytesToIgnore, (int)leftLength, (byte[])right.getRow(), (int)this.numPrefixBytesToIgnore, (int)rightLength);
    }
}

