/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.callback;

import io.datarouter.client.hbase.HBaseClientManager;
import io.datarouter.client.hbase.node.nonentity.HBaseNode;
import io.datarouter.client.hbase.util.DatarouterHBaseCounters;
import io.datarouter.instrumentation.trace.TracerTool;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientTableNodeNames;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CountingBatchCallbackFactory {
    private static final Logger logger = LoggerFactory.getLogger(CountingBatchCallback.class);
    @Inject
    private HBaseClientManager hBaseClientManager;

    public class CountingBatchCallback<R>
    implements Batch.Callback<R> {
        private final ClientId clientId;
        private final String clientName;
        private final String tableName;
        private final String opName;

        public CountingBatchCallback(HBaseNode<?, ?, ?, ?, ?> node, String opName) {
            this((ClientId)node.getClientIds().get(0), node.getClientTableNodeNames(), opName);
        }

        public CountingBatchCallback(ClientId clientId, ClientTableNodeNames clientTableNodeNames, String opName) {
            this.clientId = clientId;
            this.clientName = clientTableNodeNames.getClientName();
            this.tableName = clientTableNodeNames.getTableName();
            this.opName = opName;
        }

        public void update(byte[] region, byte[] row, R result) {
            try {
                String regionName = HRegionInfo.encodeRegionName((byte[])region);
                Connection connection = CountingBatchCallbackFactory.this.hBaseClientManager.getConnection(this.clientId);
                RegionLocator regionLocator = connection.getRegionLocator(TableName.valueOf((String)this.tableName));
                HRegionLocation regionLocation = regionLocator.getRegionLocation(row);
                ServerName serverName = regionLocation.getServerName();
                String hostname = serverName.getHostname();
                logger.debug("{}, {}, {}, {}, {}", new Object[]{this.clientName, this.tableName, this.opName, regionName, hostname});
                DatarouterHBaseCounters.onHBaseRowCallback(this.clientName, this.tableName, this.opName, regionName, hostname, 1L);
                TracerTool.appendToSpanInfo((TracerTool.TraceSpanInfoBuilder)new TracerTool.TraceSpanInfoBuilder().add("regionName", (Object)regionName).add("hostname", (Object)hostname));
            }
            catch (Exception e) {
                logger.warn("", (Throwable)e);
            }
        }
    }
}

