/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.client.hbase.client;

import io.datarouter.storage.client.ClientOptions;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HBaseOptions {
    private static final String PREFIX_hbase = "hbase.";
    protected static final String PROP_zookeeperQuorum = "zookeeper.quorum";
    protected static final String PROP_maxHTables = "maxHTables";
    protected static final String PROP_minThreadsPerHTable = "minThreadsPerHTable";
    protected static final String PROP_maxThreadsPerHTable = "maxThreadsPerHTable";
    protected static final String PROP_minPoolSize = "minPoolSize";
    @Inject
    private ClientOptions clientOptions;

    public String zookeeperQuorum(String clientName) {
        return this.clientOptions.getRequiredString(clientName, HBaseOptions.makeHbaseKey(PROP_zookeeperQuorum));
    }

    public Integer maxHTables(String clientName, int def) {
        return this.clientOptions.optString(clientName, HBaseOptions.makeHbaseKey(PROP_maxHTables)).map(Integer::valueOf).orElse(def);
    }

    public Integer minThreadsPerHTable(String clientName, int def) {
        return this.clientOptions.optString(clientName, HBaseOptions.makeHbaseKey(PROP_minThreadsPerHTable)).map(Integer::valueOf).orElse(def);
    }

    public Integer maxThreadsPerHTable(String clientName, int def) {
        return this.clientOptions.optString(clientName, HBaseOptions.makeHbaseKey(PROP_maxThreadsPerHTable)).map(Integer::valueOf).orElse(def);
    }

    protected static String makeHbaseKey(String propertyKey) {
        return PREFIX_hbase + propertyKey;
    }
}

