/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.gcp.bigtable.config;

import io.datarouter.auth.role.DatarouterUserRole;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.gcp.bigtable.config.BigtableHbaseProjectIdAndInstanceIdSupplier;
import io.datarouter.web.dispatcher.DispatchRule;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.DynamicNavBarItem;
import io.datarouter.web.navigation.NavBarCategory;
import io.datarouter.web.navigation.NavBarItem;
import jakarta.inject.Inject;

public class GcpBigTableNavBarItem
implements DynamicNavBarItem {
    @Inject
    private BigtableHbaseProjectIdAndInstanceIdSupplier supplier;

    public NavBarItem getNavBarItem() {
        String projectId = this.supplier.getBigtableHbaseProjectIdAndInstanceId().projectId;
        String instanceId = this.supplier.getBigtableHbaseProjectIdAndInstanceId().instanceId;
        String link = "https://console.cloud.google.com/bigtable/instances/" + instanceId + "/overview?project=" + projectId;
        return new NavBarItem.NavBarItemBuilder((NavBarCategory)DatarouterNavBarCategory.EXTERNAL, link, "GCP Bigtable").openInNewTab().setDispatchRule(new DispatchRule().allowRoles(new RoleEnum[]{DatarouterUserRole.DATAROUTER_MONITORING})).build();
    }

    public Boolean shouldDisplay() {
        String projectId = this.supplier.getBigtableHbaseProjectIdAndInstanceId().projectId;
        String instanceId = this.supplier.getBigtableHbaseProjectIdAndInstanceId().instanceId;
        if (!projectId.isEmpty() && !instanceId.isEmpty()) {
            return true;
        }
        return false;
    }

    public NavBarCategory.NavBarItemType getType() {
        return NavBarCategory.NavBarItemType.DATAROUTER;
    }
}

