/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.writer;

import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.compress.CompressedBlocks;
import io.datarouter.util.Require;
import io.datarouter.util.number.NumberFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockQueue {
    private static final Logger logger = LoggerFactory.getLogger(BlockQueue.class);
    private final String name;
    private final int targetFileBlocks;
    private final long targetFileBytes;
    private int fileId;
    private final List<CompressedBlock> blocks;
    private int head;
    private int tail;
    private int ending;
    private int numFileBlocks;
    private int numFileBytes;
    private final List<Integer> fileIds;
    private final List<Integer> endings;
    public volatile long numSingleEndingChecks;
    public volatile long numMultiEndingChecks;

    public BlockQueue(String name, long fileByteLimit, int fileBlockLimit) {
        this.name = name;
        this.targetFileBlocks = fileBlockLimit;
        this.targetFileBytes = fileByteLimit;
        this.fileId = 0;
        this.blocks = new ArrayList<CompressedBlock>();
        this.head = 0;
        this.tail = 0;
        this.ending = 0;
        this.fileIds = new ArrayList<Integer>();
        this.endings = new ArrayList<Integer>();
        this.numSingleEndingChecks = 0L;
        this.numMultiEndingChecks = 0L;
    }

    public synchronized List<SnapshotFile> submit(int blockId, CompressedBlock block) {
        while (this.blocks.size() <= blockId) {
            this.blocks.add(null);
        }
        this.blocks.set(blockId, block);
        return this.advanceHead();
    }

    public synchronized List<SnapshotFile> takeLastFiles() {
        if (this.head == this.tail) {
            return List.of();
        }
        return List.of(this.takeFile(this.head));
    }

    private List<SnapshotFile> advanceHead() {
        CompressedBlock block;
        ArrayList<SnapshotFile> files = new ArrayList<SnapshotFile>();
        while (this.head < this.blocks.size() && (block = this.blocks.get(this.head)) != null) {
            ++this.head;
            this.fileIds.add(this.fileId);
            this.ending += block.totalLength;
            this.endings.add(this.ending);
            ++this.numFileBlocks;
            this.numFileBytes += block.totalLength;
            if (this.numFileBlocks < this.targetFileBlocks && (long)this.numFileBytes < this.targetFileBytes) continue;
            SnapshotFile snapshotFile = this.takeFile(this.head);
            ++this.fileId;
            this.ending = 0;
            this.numFileBlocks = 0;
            this.numFileBytes = 0;
            files.add(snapshotFile);
        }
        return files;
    }

    private SnapshotFile takeFile(int to) {
        Require.isTrue((to <= this.head ? 1 : 0) != 0);
        int length = to - this.tail;
        ArrayList<CompressedBlock> fileBlocks = new ArrayList<CompressedBlock>(length);
        int i = 0;
        while (i < length) {
            CompressedBlock block = this.blocks.get(this.tail + i);
            fileBlocks.add(block);
            this.blocks.set(this.tail + i, null);
            ++i;
        }
        this.tail += length;
        SnapshotFile snapshotFile = new SnapshotFile(this.name, this.fileId, new CompressedBlocks(fileBlocks));
        logger.info("takeFile {}", (Object)snapshotFile.getFlushLog());
        return snapshotFile;
    }

    public synchronized int[] fileIds(int firstBlockId, int numBlocks) {
        int[] foundFileIds = new int[numBlocks];
        int i = 0;
        while (i < numBlocks) {
            foundFileIds[i] = this.fileIds.get(firstBlockId + i);
            ++i;
        }
        return foundFileIds;
    }

    public synchronized Integer ending(int blockId) {
        ++this.numSingleEndingChecks;
        if (blockId >= this.endings.size()) {
            return null;
        }
        return this.endings.get(blockId);
    }

    public synchronized boolean isReady(int firstBlockId, int numBlocks) {
        int blockId = firstBlockId + numBlocks - 1;
        while (blockId >= firstBlockId) {
            if (blockId >= this.head) {
                return false;
            }
            --blockId;
        }
        return true;
    }

    public synchronized FileIdsAndEndings fileIdsAndEndings(int firstBlockId, int numBlocks) {
        int[] foundFileIds = new int[numBlocks];
        int[] foundEndings = new int[numBlocks];
        if (firstBlockId < 0) {
            foundFileIds[0] = 0;
            foundEndings[0] = 0;
        } else {
            foundFileIds[0] = this.fileIds.get(firstBlockId);
            foundEndings[0] = this.endings.get(firstBlockId);
        }
        int i = 1;
        while (i < numBlocks) {
            foundFileIds[i] = this.fileIds.get(firstBlockId + i);
            foundEndings[i] = this.endings.get(firstBlockId + i);
            ++i;
        }
        return new FileIdsAndEndings(foundFileIds, foundEndings);
    }

    public void assertEmpty() {
        Require.equals((Object)this.tail, (Object)this.head);
        Require.equals((Object)this.tail, (Object)this.blocks.size());
        Require.equals((Object)this.tail, (Object)this.fileIds.size());
        Require.equals((Object)this.tail, (Object)this.endings.size());
    }

    public static class FileIdsAndEndings {
        public final int[] fileIds;
        public final int[] endings;

        public FileIdsAndEndings(int[] fileIds, int[] endings) {
            this.fileIds = fileIds;
            this.endings = endings;
        }
    }

    public static class SnapshotFile {
        public final String type;
        public final int id;
        public final CompressedBlocks compressedBlocks;

        public SnapshotFile(String type, int id, CompressedBlocks blocks) {
            this.type = type;
            this.id = id;
            this.compressedBlocks = blocks;
        }

        public byte[] concat() {
            return this.compressedBlocks.concat();
        }

        public String getFlushLog() {
            return String.format("type=%s, id=%s, numBlocks=%s, numBytes=%s", this.type, this.id, NumberFormatter.addCommas((Number)this.compressedBlocks.count), NumberFormatter.addCommas((Number)this.compressedBlocks.totalLength));
        }
    }
}

