/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.storage.block;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.compress.CompressedBlock;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorage;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorageReader;

public class CachingBlockStorageReader
implements SnapshotBlockStorageReader {
    private static final int MAX_CACHEABLE_BYTES = 0x100000;
    private final SnapshotBlockStorageReader source;
    private final SnapshotBlockStorage cache;

    public CachingBlockStorageReader(SnapshotBlockStorageReader back, SnapshotBlockStorage front) {
        this.source = back;
        this.cache = front;
    }

    @Override
    public byte[] getRootBlock() {
        byte[] bytes = this.cache.getRootBlock();
        if (bytes == null && (bytes = this.source.getRootBlock()).length < 0x100000) {
            this.cache.addRootBlock(new EncodedBlock(bytes));
        }
        return bytes;
    }

    @Override
    public byte[] getBranchBlock(SnapshotPaths paths, BlockKey blockKey) {
        byte[] bytes = this.cache.getBranchBlock(paths, blockKey);
        if (bytes == null && (bytes = this.source.getBranchBlock(paths, blockKey)).length < 0x100000) {
            this.cache.addBranchBlock(paths, blockKey.toCacheBlockKey(), new CompressedBlock(bytes));
        }
        return bytes;
    }

    @Override
    public byte[] getLeafBlock(SnapshotPaths paths, BlockKey blockKey) {
        byte[] bytes = this.cache.getLeafBlock(paths, blockKey);
        if (bytes == null && (bytes = this.source.getLeafBlock(paths, blockKey)).length < 0x100000) {
            this.cache.addLeafBlock(paths, blockKey.toCacheBlockKey(), new CompressedBlock(bytes));
        }
        return bytes;
    }

    @Override
    public byte[] getValueBlock(SnapshotPaths paths, BlockKey blockKey) {
        byte[] bytes = this.cache.getValueBlock(paths, blockKey);
        if (bytes == null && (bytes = this.source.getValueBlock(paths, blockKey)).length < 0x100000) {
            this.cache.addValueBlock(paths, blockKey.toCacheBlockKey(), new CompressedBlock(bytes));
        }
        return bytes;
    }
}

