/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader.record;

import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import java.util.Arrays;
import java.util.Comparator;

public class SnapshotRecord {
    public static final Comparator<SnapshotRecord> KEY_COMPARATOR = Comparator.comparing(snapshotRecord -> snapshotRecord.key, (a, b) -> Arrays.compareUnsigned(a, b));
    public final long id;
    public final byte[] key;
    public final byte[] value;
    public final byte[][] columnValues;

    public SnapshotRecord(long id, SnapshotEntry entry) {
        this(id, entry.key(), entry.value(), entry.columnValues);
    }

    public SnapshotRecord(long id, byte[] key, byte[] value, byte[][] columnValues) {
        this.id = id;
        this.key = key;
        this.value = value;
        this.columnValues = columnValues;
    }

    public SnapshotEntry entry() {
        return new SnapshotEntry(this.key, this.value, this.columnValues);
    }
}

