/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.value;

import io.datarouter.filesystem.snapshot.block.BlockSizeCalculator;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.model.util.Bytes;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.bytes.ByteReader;
import io.datarouter.util.bytes.IntegerByteTool;

public class ValueBlockV1
implements ValueBlock {
    public static final String FORMAT = "valueV1";
    private static final int HEAP_SIZE_OVERHEAD = new BlockSizeCalculator().addObjectHeaders(1).addArrays(1).addInts(3).calculate();
    private final byte[] bytes;
    private final int numValues;
    private final int endingSectionOffset;
    private final int valueSectionOffset;

    public ValueBlockV1(byte[] bytes) {
        this.bytes = bytes;
        ByteReader reader = new ByteReader(bytes);
        this.numValues = reader.varInt();
        this.endingSectionOffset = reader.position();
        reader.skipInts(this.numValues);
        this.valueSectionOffset = reader.position();
        reader.skip(this.valueEnding(this.numValues - 1));
        reader.assertFinished();
    }

    @Override
    public int heapSize() {
        return HEAP_SIZE_OVERHEAD + BlockSizeCalculator.pad(this.bytes.length);
    }

    @Override
    public int numValues() {
        return this.numValues;
    }

    @Override
    public Bytes value(int index) {
        int start = index == 0 ? 0 : this.valueEnding(index - 1);
        int end = this.valueEnding(index);
        int length = end - start;
        return new Bytes(this.bytes, this.valueSectionOffset + start, length);
    }

    @Override
    public Scanner<Bytes> values() {
        return Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numValues).map(this::value);
    }

    private int valueEnding(int index) {
        int endingOffset = 4 * index;
        return IntegerByteTool.fromRawBytes((byte[])this.bytes, (int)(this.endingSectionOffset + endingOffset));
    }
}

