/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.leaf;

import io.datarouter.filesystem.snapshot.block.Block;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafRecord;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafSearchResult;
import io.datarouter.model.util.Bytes;
import io.datarouter.scanner.Scanner;
import java.util.Optional;

public interface LeafBlock
extends Block {
    public long recordId(int var1);

    default public long firstRecordId() {
        return this.recordId(0);
    }

    public int numRecords();

    default public Optional<Long> findRecordId(byte[] searchKey) {
        return this.findRecordIndex(searchKey).map(this::recordId);
    }

    default public Optional<Integer> findRecordIndex(byte[] searchKey) {
        int index = this.insertionIndex(searchKey);
        return index < 0 ? Optional.empty() : Optional.of(index);
    }

    default public SnapshotLeafSearchResult search(byte[] searchKey) {
        int index = this.insertionIndex(searchKey);
        boolean exactMatch = true;
        if (index < 0) {
            index = -index - 1;
            exactMatch = false;
        }
        long recordId = this.recordId(index);
        return new SnapshotLeafSearchResult(recordId, exactMatch);
    }

    default public int insertionIndex(byte[] searchKey) {
        Bytes searchKeyRange = new Bytes(searchKey);
        int low = 0;
        int mid = 0;
        int high = this.numRecords() - 1;
        int diff = 0;
        int lastMatch = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            Bytes midVal = this.blockKey(mid);
            diff = midVal.compareTo(searchKeyRange);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff == 0) {
                lastMatch = mid;
                high = mid - 1;
                continue;
            }
            high = mid - 1;
        }
        if (lastMatch >= 0) {
            return lastMatch;
        }
        if (diff < 0) {
            int insertionPoint = mid + 1;
            return -(insertionPoint + 1);
        }
        int insertionPoint = mid;
        return -(insertionPoint + 1);
    }

    public Bytes blockKey(int var1);

    default public Bytes snapshotKey(long recordId) {
        long blockRecordIndex = recordId - this.firstRecordId();
        return this.blockKey((int)blockRecordIndex);
    }

    default public Scanner<Bytes> keys() {
        return Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords()).map(this::blockKey);
    }

    default public Scanner<byte[]> keyCopies() {
        return this.keys().map(Bytes::toArray);
    }

    public Bytes blockValue(int var1);

    default public Bytes snapshotValue(long recordId) {
        int index = (int)(recordId - this.firstRecordId());
        return this.blockValue(index);
    }

    default public Scanner<Bytes> values() {
        return Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords()).map(this::blockValue);
    }

    default public Scanner<byte[]> valueCopies() {
        return this.values().map(Bytes::toArray);
    }

    default public SnapshotLeafRecord snapshotLeafRecord(long recordId) {
        byte[] key = this.snapshotKey(recordId).toArray();
        byte[] value = this.snapshotValue(recordId).toArray();
        return new SnapshotLeafRecord(recordId, key, value);
    }

    default public Scanner<SnapshotLeafRecord> leafRecords() {
        return Scanner.iterate((Object)this.firstRecordId(), i -> i + 1L).limit((long)this.numRecords()).map(this::snapshotLeafRecord);
    }

    default public ValueLocation getValueBlock(int column, long recordId) {
        int index = (int)(recordId - this.firstRecordId());
        int valueBlockOffset = this.valueBlockOffsetForKey(column, index);
        int valueBlockId = this.firstValueBlockId(column) + valueBlockOffset;
        int valueIndex = this.valueIndex(column, valueBlockOffset, index);
        return new ValueLocation(valueBlockId, valueIndex);
    }

    default public Optional<ValueLocation> findValueBlock(int column, byte[] searchKey) {
        return this.findRecordIndex(searchKey).map(index -> {
            int valueBlockOffset = this.valueBlockOffsetForKey(column, (int)index);
            int valueBlockId = this.firstValueBlockId(column) + valueBlockOffset;
            int valueIndex = this.valueIndex(column, valueBlockOffset, (int)index);
            return new ValueLocation(valueBlockId, valueIndex);
        });
    }

    public int firstValueBlockId(int var1);

    public int numValueBlocks(int var1);

    default public Scanner<Integer> valueBlockIds(int column) {
        return Scanner.iterate((Object)this.firstValueBlockId(column), i -> i + 1).limit((long)this.numValueBlocks(column));
    }

    public int valueBlockEnding(int var1, int var2);

    public BlockKey valueBlockKey(SnapshotKey var1, int var2, int var3);

    public int firstValueIndex(int var1);

    public int valueBlockOffset(int var1, int var2);

    default public int valueBlockOffsetForKey(int column, int index) {
        int valueBlockOffsetIndex = 0;
        int i = 1;
        while (i <= this.numValueBlocks(column) - 1) {
            if (this.valueBlockOffset(column, i) <= index) {
                ++valueBlockOffsetIndex;
            }
            ++i;
        }
        return valueBlockOffsetIndex;
    }

    default public int valueIndex(int column, int valueBlockOffsetForKey, int index) {
        int valueBlockOffset = valueBlockOffsetForKey;
        if (valueBlockOffset == 0) {
            return this.firstValueIndex(column) + index;
        }
        int previousValueBlockOffset = this.valueBlockOffset(column, valueBlockOffset);
        return index - previousValueBlockOffset;
    }

    public static class ValueLocation {
        public final int valueBlockId;
        public final int valueIndex;

        public ValueLocation(int valueBlockId, int valueIndex) {
            this.valueBlockId = valueBlockId;
            this.valueIndex = valueIndex;
        }
    }
}

