/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.branch;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.BlockSizeCalculator;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.model.util.Bytes;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.bytes.ByteReader;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.bytes.LongByteTool;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class BranchBlockV1
implements BranchBlock {
    public static final String FORMAT = "branchV1";
    private static final int HEAP_SIZE_OVERHEAD = new BlockSizeCalculator().addObjectHeaders(1).addArrays(1).addInts(6).calculate();
    private final byte[] bytes;
    private final int level;
    private final int firstChildBlockId;
    private final int numRecords;
    private final int recordIdsSectionOffset;
    private final int endingSectionOffset;
    private final int keySectionOffset;
    private final int childFileIdsSectionOffset;
    private final int childEndingsSectionOffset;

    public BranchBlockV1(byte[] bytes) {
        this.bytes = bytes;
        ByteReader reader = new ByteReader(bytes);
        this.level = reader.varInt();
        this.firstChildBlockId = reader.varInt();
        this.numRecords = reader.varInt();
        this.recordIdsSectionOffset = reader.position();
        reader.skipLongs(this.numRecords);
        this.endingSectionOffset = reader.position();
        reader.skipInts(this.numRecords);
        this.keySectionOffset = reader.position();
        reader.skip(this.keyEnding(this.numRecords - 1));
        int numEndings = this.numRecords + 1;
        this.childFileIdsSectionOffset = reader.position();
        reader.skipInts(numEndings);
        this.childEndingsSectionOffset = reader.position();
        reader.skipInts(numEndings);
        reader.assertFinished();
    }

    @Override
    public int heapSize() {
        return HEAP_SIZE_OVERHEAD + BlockSizeCalculator.pad(this.bytes.length);
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public int numRecords() {
        return this.numRecords;
    }

    @Override
    public long recordId(int index) {
        int bytesOffset = this.recordIdsSectionOffset + index * 8;
        return LongByteTool.fromRawBytes((byte[])this.bytes, (int)bytesOffset);
    }

    @Override
    public Bytes key(int index) {
        int start = index == 0 ? 0 : this.keyEnding(index - 1);
        int end = this.keyEnding(index);
        int length = end - start;
        return new Bytes(this.bytes, this.keySectionOffset + start, length);
    }

    @Override
    public Scanner<Bytes> keys() {
        return Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::key);
    }

    @Override
    public int childBlock(int index) {
        return this.firstChildBlockId + index;
    }

    @Override
    public Scanner<Integer> childBlockIds() {
        return Scanner.iterate((Object)this.firstChildBlockId, i -> i + 1).limit((long)this.numRecords);
    }

    @Override
    public BlockKey childBranchBlockKey(SnapshotKey snapshotKey, int childBlockId) {
        int childLevel = this.level - 1;
        int fileId = this.childBlockFileId(childBlockId);
        int start = this.isFirstBlockInFile(childBlockId) ? 0 : this.childBlockEnding(childBlockId - 1);
        int end = this.childBlockEnding(childBlockId);
        int length = end - start;
        return BlockKey.branch(snapshotKey, childLevel, childBlockId, fileId, start, length);
    }

    @Override
    public BlockKey leafBlockKey(SnapshotKey snapshotKey, int leafBlockId) {
        int fileId = this.childBlockFileId(leafBlockId);
        int start = this.isFirstBlockInFile(leafBlockId) ? 0 : this.childBlockEnding(leafBlockId - 1);
        int end = this.childBlockEnding(leafBlockId);
        int length = end - start;
        return BlockKey.leaf(snapshotKey, leafBlockId, fileId, start, length);
    }

    private int keyEnding(int index) {
        int endingOffset = 4 * index;
        return IntegerByteTool.fromRawBytes((byte[])this.bytes, (int)(this.endingSectionOffset + endingOffset));
    }

    private boolean isFirstBlockInFile(int childBlockId) {
        int fileId;
        if (childBlockId == 0) {
            return true;
        }
        int previousFileId = this.childBlockFileId(childBlockId - 1);
        return previousFileId != (fileId = this.childBlockFileId(childBlockId));
    }

    private int childBlockFileId(int childBlockId) {
        int childBlockIndex = childBlockId - this.firstChildBlockId;
        int indexExcludingPreviousEndings = childBlockIndex + 1;
        int endingOffset = 4 * indexExcludingPreviousEndings;
        return IntegerByteTool.fromRawBytes((byte[])this.bytes, (int)(this.childFileIdsSectionOffset + endingOffset));
    }

    private int childBlockEnding(int childBlockId) {
        int childBlockIndex = childBlockId - this.firstChildBlockId;
        int indexExcludingPreviousEndings = childBlockIndex + 1;
        int endingOffset = 4 * indexExcludingPreviousEndings;
        return IntegerByteTool.fromRawBytes((byte[])this.bytes, (int)(this.childEndingsSectionOffset + endingOffset));
    }

    @Override
    public String toDetailedString() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("                   level " + this.level);
        lines.add("previousBlockFinalEnding " + this.childBlockEnding(-1));
        lines.add("       firstChildBlockId " + this.firstChildBlockId);
        lines.add("              numRecords " + this.numRecords());
        lines.add("               recordIds " + (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::recordId).map(Object::toString).collect(Collectors.joining(",", "[", "]")));
        lines.add("              keyEndings " + (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::keyEnding).map(Object::toString).collect(Collectors.joining(",", "[", "]")));
        lines.add("                childIds " + (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::childBlock).map(Object::toString).collect(Collectors.joining(",", "[", "]")));
        lines.add("            childEndings " + (String)Scanner.iterate((Object)0, i -> i + 1).limit((long)this.numRecords).map(this::childBlockEnding).map(Object::toString).collect(Collectors.joining(",", "[", "]")));
        return "\n" + lines.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

