/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw;

import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.Scanner;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PathService {
    @Inject
    private CheckedPathService checkedPathService;

    public static String pathToString(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) ? String.valueOf(path.toString()) + "/" : path.toString();
    }

    public List<Path> listChildren(Path fullPath, Set<String> excludingFilenames, int limit, boolean sorted) {
        try {
            return this.checkedPathService.listChildren(fullPath, excludingFilenames, limit, sorted);
        }
        catch (NoSuchFileException e) {
            return List.of();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Scanner<List<Path>> scanDescendantsPaged(Path fullPath, boolean includeDirectories, boolean sorted) {
        return Scanner.of(this.listChildren(fullPath, Set.of(), Integer.MAX_VALUE, sorted)).splitBy(path -> Files.isDirectory(path, new LinkOption[0])).map(Scanner::list).concat(directoriesOrFiles -> {
            if (!Files.isDirectory((Path)directoriesOrFiles.get(0), new LinkOption[0])) {
                return ObjectScanner.of((Object)directoriesOrFiles);
            }
            return Scanner.of((Iterable)directoriesOrFiles).concat(directory -> includeDirectories ? ObjectScanner.of(List.of(directory)).append(this.scanDescendantsPaged((Path)directory, includeDirectories, sorted)) : this.scanDescendantsPaged((Path)directory, includeDirectories, sorted));
        });
    }

    public Long size(Path path) {
        try {
            return this.checkedPathService.size(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(Path fullPath) {
        try {
            this.checkedPathService.delete(fullPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Singleton
    public static class CheckedPathService {
        public static final Comparator<Path> PATH_COMPARATOR = Comparator.comparing(PathService::pathToString);

        public List<Path> listChildren(Path fullPath, Set<String> excludingFilenames, int limit, boolean sorted) throws IOException {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DirectoryStream<Path> iterable = Files.newDirectoryStream(fullPath);){
                Scanner childPaths = Scanner.of(iterable).exclude(path -> excludingFilenames.contains(path.getFileName().toString()));
                if (sorted) {
                    childPaths = childPaths.sort(PATH_COMPARATOR);
                }
                return childPaths.limit((long)limit).list();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public Long size(Path path) throws IOException {
            return Files.size(path);
        }

        public void delete(Path fullPath) throws IOException {
            Files.deleteIfExists(fullPath);
        }
    }
}

