/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.web;

import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.SnapshotGroups;
import io.datarouter.filesystem.snapshot.web.DatarouterSnapshotPaths;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJsV2;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H4Tag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.TheadTag;
import javax.inject.Inject;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterSnapshotGroupHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterSnapshotGroupHandler.class);
    private static final String P_groupId = "groupId";
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private DatarouterSnapshotPaths snapshotPaths;
    @Inject
    private SnapshotGroups groups;

    @BaseHandler.Handler
    public Mav listSnapshots(@Param(value="groupId") String groupId) {
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Filesystem - Snapshots in group").withRequires(new String[]{DatarouterWebRequireJsV2.SORTTABLE}).withContent(this.buildSnapshotList(groupId)).buildMav();
    }

    private ContainerTag<?> buildSnapshotList(String groupId) {
        logger.warn("hello");
        SnapshotGroup group = this.groups.getGroup(groupId);
        TheadTag thead = TagCreator.thead((DomContent[])new DomContent[]{TagCreator.tr((DomContent[])new DomContent[]{TagCreator.th((String)"id"), TagCreator.th((String)"summary"), TagCreator.td((String)"entries")})});
        TableTag table = (TableTag)((TableTag)TagCreator.table().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"})).with((DomContent)thead);
        group.keyReadOps(false).scanSnapshotKeys().map(snapshotKey -> {
            TdTag idTd = TagCreator.td((String)snapshotKey.snapshotId);
            String summaryHref = new URIBuilder().setPath(String.valueOf(this.request.getContextPath()) + this.snapshotPaths.datarouter.snapshot.individual.summary.toSlashedString()).addParameter(P_groupId, snapshotKey.groupId).addParameter("snapshotId", snapshotKey.snapshotId).toString();
            TdTag summaryTd = TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)"summary").withHref(summaryHref)});
            String entriesHref = new URIBuilder().setPath(String.valueOf(this.request.getContextPath()) + this.snapshotPaths.datarouter.snapshot.individual.entries.toSlashedString()).addParameter(P_groupId, snapshotKey.groupId).addParameter("snapshotId", snapshotKey.snapshotId).toString();
            TdTag entriesTd = TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)"entries").withHref(entriesHref)});
            return TagCreator.tr((DomContent[])new DomContent[]{idTd, summaryTd, entriesTd});
        }).forEach(arg_0 -> ((TableTag)table).with(arg_0));
        H4Tag header = TagCreator.h4((String)("Snapshots in group: " + group.getGroupId()));
        return (ContainerTag)((DivTag)TagCreator.div((DomContent[])new DomContent[]{header, table}).withClass("container-fluid my-4")).withStyle("padding-left: 0px");
    }
}

