/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.storage.file;

import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.path.SnapshotPathsRegistry;
import io.datarouter.filesystem.snapshot.storage.file.FileKey;
import io.datarouter.filesystem.snapshot.storage.file.SnapshotFileStorage;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.number.NumberFormatter;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotFileDeleter {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotFileDeleter.class);
    private final SnapshotKey snapshotKey;
    private final SnapshotFileStorage snapshotFileStorage;
    private final int numThreads;
    private final RootBlock rootBlock;
    private final SnapshotPaths paths;
    private final ExecutorService exec;

    public SnapshotFileDeleter(RootBlock rootBlock, SnapshotPathsRegistry pathsRegistry, SnapshotKey snapshotKey, SnapshotFileStorage snapshotFileStorage, ExecutorService exec, int numThreads) {
        this.rootBlock = rootBlock;
        this.paths = pathsRegistry.getPaths(rootBlock.pathFormat());
        this.snapshotKey = snapshotKey;
        this.snapshotFileStorage = snapshotFileStorage;
        this.exec = exec;
        this.numThreads = numThreads;
    }

    public void delete() {
        this.deleteBranchFiles();
        this.deleteLeafFiles();
        this.deleteValueFiles();
        this.snapshotFileStorage.deleteRootFile();
        try {
            this.snapshotFileStorage.deleteAll();
        }
        catch (UnsupportedOperationException e) {
            logger.warn("", (Throwable)e);
        }
        logger.info("deleted snapshot key={}, bytes={}", (Object)this.snapshotKey, (Object)NumberFormatter.addCommas((Number)this.rootBlock.totalBytesCompressed()));
    }

    private void deleteBranchFiles() {
        IntStream.range(0, this.rootBlock.numBranchLevels()).forEach(level -> {
            int lastBlockId = this.rootBlock.numBranchBlocks(level) - 1;
            int numFiles = this.rootBlock.branchFileId(level, lastBlockId) + 1;
            Scanner.iterate((Object)0, i -> i + 1).limit((long)numFiles).map(fileId -> FileKey.branch(level, fileId)).parallel(new ParallelScannerContext(this.exec, this.numThreads, true)).forEach(this::tryDeleteBranchFile);
        });
    }

    private void tryDeleteBranchFile(FileKey fileKey) {
        try {
            this.snapshotFileStorage.deleteBranchFile(this.paths, fileKey);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private void deleteLeafFiles() {
        int lastBlockId = this.rootBlock.numLeafBlocks() - 1;
        int numFiles = this.rootBlock.leafFileId(lastBlockId) + 1;
        Scanner.iterate((Object)0, i -> i + 1).limit((long)numFiles).map(FileKey::leaf).parallel(new ParallelScannerContext(this.exec, this.numThreads, true)).forEach(this::tryDeleteLeafFile);
    }

    private void tryDeleteLeafFile(FileKey fileKey) {
        try {
            this.snapshotFileStorage.deleteLeafFile(this.paths, fileKey);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private void deleteValueFiles() {
        IntStream.range(0, this.rootBlock.numColumns()).forEach(column -> {
            int lastBlockId = this.rootBlock.numValueBlocks(column) - 1;
            int numFiles = this.rootBlock.valueFileId(lastBlockId) + 1;
            Scanner.iterate((Object)0, i -> i + 1).limit((long)numFiles).map(fileId -> FileKey.value(column, fileId)).parallel(new ParallelScannerContext(this.exec, this.numThreads, true)).forEach(this::tryDeleteValueFile);
        });
    }

    private void tryDeleteValueFile(FileKey fileKey) {
        try {
            this.snapshotFileStorage.deleteValueFile(this.paths, fileKey);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }
}

