/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.cache;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockRangeLoader;
import io.datarouter.scanner.Scanner;
import java.util.stream.IntStream;

public class LatestBlockCache
implements BlockLoader {
    private final BlockLoader blockLoader;
    private final int[] branchIndexes;
    private final BranchBlock[] branchBlocks;
    private int leafIndex;
    private LeafBlock leafBlock;
    private int[] valueIndexes;
    private ValueBlock[] valueBlocks;

    public LatestBlockCache(SnapshotKey snapshotKey, BlockLoader blockLoader) {
        this.blockLoader = blockLoader;
        RootBlock rootBlock = blockLoader.root(BlockKey.root(snapshotKey));
        int numBranchLevels = rootBlock.numBranchLevels();
        this.branchIndexes = IntStream.range(0, numBranchLevels).map($ -> -1).toArray();
        this.branchBlocks = new BranchBlock[numBranchLevels];
        this.leafIndex = -1;
        int numColumns = rootBlock.numColumns();
        this.valueIndexes = IntStream.range(0, numColumns).map($ -> -1).toArray();
        this.valueBlocks = new ValueBlock[numColumns];
    }

    @Override
    public RootBlock root(BlockKey key) {
        return this.blockLoader.root(key);
    }

    @Override
    public BranchBlock branch(BlockKey key) {
        if (this.branchIndexes[key.level] != key.blockId) {
            this.branchBlocks[key.level] = this.blockLoader.branch(key);
            this.branchIndexes[key.level] = key.blockId;
        }
        return this.branchBlocks[key.level];
    }

    @Override
    public LeafBlock leaf(BlockKey key) {
        if (this.leafIndex != key.blockId) {
            this.leafBlock = this.blockLoader.leaf(key);
            this.leafIndex = key.blockId;
        }
        return this.leafBlock;
    }

    @Override
    public Scanner<LeafBlock> leafRange(LeafBlockRangeLoader.LeafBlockRange range) {
        return this.blockLoader.leafRange(range);
    }

    @Override
    public ValueBlock value(BlockKey key) {
        if (this.valueIndexes[key.column] != key.blockId) {
            this.valueBlocks[key.column] = this.blockLoader.value(key);
            this.valueIndexes[key.column] = key.blockId;
        }
        return this.valueBlocks[key.column];
    }
}

