/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader.block;

import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.compress.BlockDecompressor;
import io.datarouter.filesystem.snapshot.compress.BlockDecompressorFactory;
import io.datarouter.filesystem.snapshot.encode.BlockDecoder;
import io.datarouter.filesystem.snapshot.encode.BlockDecoderFactory;
import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.path.SnapshotPathsRegistry;
import io.datarouter.filesystem.snapshot.reader.block.DecodingBlockLoader;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorageReader;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DecodingBlockLoaderFactory {
    @Inject
    private SnapshotPathsRegistry pathsRegistry;
    @Inject
    private BlockDecoderFactory blockDecoderFactory;
    @Inject
    private BlockDecompressorFactory blockDecompressorFactory;

    public DecodingBlockLoader create(RootBlock rootBlock, SnapshotBlockStorageReader snapshotBlockStorageReader) {
        BlockDecoder blockDecoder = this.blockDecoderFactory.create(rootBlock);
        SnapshotPaths paths = this.pathsRegistry.getPaths(rootBlock.pathFormat());
        BlockDecompressor blockDecompressor = this.blockDecompressorFactory.create(rootBlock);
        return new DecodingBlockLoader(snapshotBlockStorageReader, paths, blockDecompressor, blockDecoder);
    }
}

