/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.cache.LatestBlockCache;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotRecord;
import io.datarouter.model.util.Bytes;
import java.util.Optional;

public class SnapshotKeyReader {
    private final SnapshotKey snapshotKey;
    private final BlockLoader blockLoader;
    private final RootBlock rootBlock;

    public SnapshotKeyReader(SnapshotKey snapshotKey, BlockLoader blockLoader) {
        this.snapshotKey = snapshotKey;
        this.blockLoader = new LatestBlockCache(snapshotKey, blockLoader);
        this.rootBlock = blockLoader.root(BlockKey.root(snapshotKey));
        if (!this.rootBlock.sorted()) {
            String message = String.format("%s only supported for sorted snapshots", this.getClass().getSimpleName());
            throw new IllegalStateException(message);
        }
    }

    public Optional<Long> findRecordId(byte[] searchKey) {
        LeafBlock leafBlock = this.leafBlock(searchKey);
        return leafBlock.findRecordId(searchKey);
    }

    public Optional<SnapshotRecord> findRecord(byte[] searchKey) {
        LeafBlock leafBlock = this.leafBlock(searchKey);
        Optional<Long> optRecordId = leafBlock.findRecordId(searchKey);
        if (optRecordId.isEmpty()) {
            return Optional.empty();
        }
        long recordId = optRecordId.get();
        byte[] value = leafBlock.snapshotValue(recordId).toArray();
        int numColumns = this.rootBlock.numColumns();
        byte[][] columnValues = new byte[numColumns][];
        int column = 0;
        while (column < numColumns) {
            Optional<LeafBlock.ValueLocation> optValueLocation = leafBlock.findValueBlock(column, searchKey);
            if (optValueLocation.isEmpty()) {
                return Optional.empty();
            }
            LeafBlock.ValueLocation valueLocation = optValueLocation.get();
            BlockKey valueBlockKey = leafBlock.valueBlockKey(this.snapshotKey, column, valueLocation.valueBlockId);
            ValueBlock valueBlock = this.blockLoader.value(valueBlockKey);
            Bytes columnValue = valueBlock.value(valueLocation.valueIndex);
            columnValues[column] = columnValue.toArray();
            ++column;
        }
        return Optional.of(new SnapshotRecord(recordId, searchKey, value, columnValues));
    }

    public LeafBlock leafBlock(byte[] searchKey) {
        BlockKey rootBranchBlockKey = this.rootBlock.rootBranchBlockKey(this.snapshotKey);
        BranchBlock branchBlock = this.blockLoader.branch(rootBranchBlockKey);
        int level = this.rootBlock.maxBranchLevel() - 1;
        while (level >= 0) {
            int childBlockIndex = branchBlock.findChildBlockIndex(searchKey);
            int childBlockId = branchBlock.childBlock(childBlockIndex);
            BlockKey branchBlockKey = branchBlock.childBranchBlockKey(this.snapshotKey, childBlockId);
            branchBlock = this.blockLoader.branch(branchBlockKey);
            --level;
        }
        int leafBlockIndex = branchBlock.findChildBlockIndex(searchKey);
        int leafBlockId = branchBlock.childBlock(leafBlockIndex);
        BlockKey leafBlockKey = branchBlock.leafBlockKey(this.snapshotKey, leafBlockId);
        return this.blockLoader.leaf(leafBlockKey);
    }
}

