/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.reader;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.cache.LatestBlockCache;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotLeafRecord;
import io.datarouter.filesystem.snapshot.reader.record.SnapshotRecord;
import io.datarouter.model.util.Bytes;

public class SnapshotIdReader {
    private final SnapshotKey snapshotKey;
    private final BlockLoader blockLoader;
    private final RootBlock rootBlock;

    public SnapshotIdReader(SnapshotKey snapshotKey, BlockLoader blockLoader) {
        this.snapshotKey = snapshotKey;
        this.blockLoader = new LatestBlockCache(snapshotKey, blockLoader);
        this.rootBlock = blockLoader.root(BlockKey.root(snapshotKey));
    }

    public SnapshotLeafRecord leafRecord(long recordId) {
        LeafBlock leafBlock = this.leafBlock(recordId);
        return leafBlock.snapshotLeafRecord(recordId);
    }

    public SnapshotRecord getRecord(long recordId) {
        LeafBlock leafBlock = this.leafBlock(recordId);
        Bytes key = leafBlock.snapshotKey(recordId);
        Bytes value = leafBlock.snapshotValue(recordId);
        int numColumns = this.rootBlock.numColumns();
        byte[][] columnValues = new byte[numColumns][];
        int column = 0;
        while (column < numColumns) {
            LeafBlock.ValueLocation valueLocation = leafBlock.getValueBlock(column, recordId);
            BlockKey valueBlockKey = leafBlock.valueBlockKey(this.snapshotKey, column, valueLocation.valueBlockId);
            ValueBlock valueBlock = this.blockLoader.value(valueBlockKey);
            Bytes columnValue = valueBlock.value(valueLocation.valueIndex);
            columnValues[column] = columnValue.toArray();
            ++column;
        }
        return new SnapshotRecord(recordId, key.toArray(), value.toArray(), columnValues);
    }

    private LeafBlock leafBlock(long recordId) {
        BlockKey rootBranchBlockKey = this.rootBlock.rootBranchBlockKey(this.snapshotKey);
        BranchBlock branchBlock = this.blockLoader.branch(rootBranchBlockKey);
        int level = this.rootBlock.maxBranchLevel() - 1;
        while (level >= 0) {
            int childBlockIndex = branchBlock.findChildBlockIndex(recordId);
            int childBlockId = branchBlock.childBlock(childBlockIndex);
            BlockKey branchBlockKey = branchBlock.childBranchBlockKey(this.snapshotKey, childBlockId);
            branchBlock = this.blockLoader.branch(branchBlockKey);
            --level;
        }
        int leafBlockIndex = branchBlock.findChildBlockIndex(recordId);
        int leafBlockId = branchBlock.childBlock(leafBlockIndex);
        BlockKey leafBlockKey = branchBlock.leafBlockKey(this.snapshotKey, leafBlockId);
        return this.blockLoader.leaf(leafBlockKey);
    }
}

