/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block;

import io.datarouter.filesystem.snapshot.block.branch.BranchBlock;
import io.datarouter.filesystem.snapshot.block.branch.BranchBlockV1;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlockV1;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlockV1;
import io.datarouter.filesystem.snapshot.block.value.ValueBlock;
import io.datarouter.filesystem.snapshot.block.value.ValueBlockV1;
import io.datarouter.util.Require;
import io.datarouter.util.lang.ReflectionTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class BlockTypeRegistry {
    private final Map<String, Class<? extends RootBlock>> rootClassByName = new HashMap<String, Class<? extends RootBlock>>();
    private final Map<String, Class<? extends BranchBlock>> branchClassByName = new HashMap<String, Class<? extends BranchBlock>>();
    private final Map<String, Class<? extends LeafBlock>> leafClassByName = new HashMap<String, Class<? extends LeafBlock>>();
    private final Map<String, Class<? extends ValueBlock>> valueClassByName = new HashMap<String, Class<? extends ValueBlock>>();

    public BlockTypeRegistry() {
        this.registerRoot("rootV1", RootBlockV1.class);
        this.registerBranch("branchV1", BranchBlockV1.class);
        this.registerLeaf("keyV1", LeafBlockV1.class);
        this.registerValue("valueV1", ValueBlockV1.class);
    }

    public BlockTypeRegistry registerRoot(String name, Class<? extends RootBlock> blockClass) {
        Require.notContains(this.rootClassByName.keySet(), (Object)name);
        this.rootClassByName.put(name, blockClass);
        return this;
    }

    public BlockTypeRegistry registerBranch(String name, Class<? extends BranchBlock> blockClass) {
        Require.notContains(this.branchClassByName.keySet(), (Object)name);
        this.branchClassByName.put(name, blockClass);
        return this;
    }

    public BlockTypeRegistry registerLeaf(String name, Class<? extends LeafBlock> blockClass) {
        Require.notContains(this.leafClassByName.keySet(), (Object)name);
        this.leafClassByName.put(name, blockClass);
        return this;
    }

    public BlockTypeRegistry registerValue(String name, Class<? extends ValueBlock> blockClass) {
        Require.notContains(this.valueClassByName.keySet(), (Object)name);
        this.valueClassByName.put(name, blockClass);
        return this;
    }

    public Class<? extends RootBlock> getRootClass(String name) {
        return this.rootClassByName.get(name);
    }

    public Class<? extends BranchBlock> getBranchClass(String name) {
        return this.branchClassByName.get(name);
    }

    public Class<? extends LeafBlock> getLeafClass(String name) {
        return this.leafClassByName.get(name);
    }

    public Class<? extends ValueBlock> getValueClass(String name) {
        return this.valueClassByName.get(name);
    }

    public RootBlock decodeRoot(String typeName, byte[] bytes) {
        return (RootBlock)ReflectionTool.createWithParameters(this.getRootClass(typeName), List.of(bytes));
    }

    public BranchBlock decodeBranch(String typeName, byte[] bytes) {
        return (BranchBlock)ReflectionTool.createWithParameters(this.getBranchClass(typeName), List.of(bytes));
    }

    public LeafBlock decodeLeaf(String typeName, byte[] bytes) {
        return (LeafBlock)ReflectionTool.createWithParameters(this.getLeafClass(typeName), List.of(bytes));
    }

    public ValueBlock decodeValue(String typeName, byte[] bytes) {
        return (ValueBlock)ReflectionTool.createWithParameters(this.getValueClass(typeName), List.of(bytes));
    }
}

