/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.storage.block;

import io.datarouter.filesystem.snapshot.block.BlockType;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;

public class CacheBlockKey {
    public final SnapshotKey snapshotKey;
    public final BlockType type;
    public final int level;
    public final int column;
    public final int blockId;

    public CacheBlockKey(SnapshotKey snapshotKey, BlockType type, int level, int column, int blockId) {
        this.snapshotKey = snapshotKey;
        this.type = type;
        this.level = level;
        this.column = column;
        this.blockId = blockId;
    }

    public static CacheBlockKey root(SnapshotKey snapshotKey) {
        return new CacheBlockKey(snapshotKey, BlockType.ROOT, -1, -1, -1);
    }

    public static CacheBlockKey branch(SnapshotKey snapshotKey, int level, int id) {
        return new CacheBlockKey(snapshotKey, BlockType.BRANCH, level, -1, id);
    }

    public static CacheBlockKey leaf(SnapshotKey snapshotKey, int id) {
        return new CacheBlockKey(snapshotKey, BlockType.LEAF, -1, -1, id);
    }

    public static CacheBlockKey value(SnapshotKey snapshotKey, int column, int id) {
        return new CacheBlockKey(snapshotKey, BlockType.VALUE, -1, column, id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.blockId;
        result = 31 * result + this.level;
        result = 31 * result + (this.snapshotKey == null ? 0 : this.snapshotKey.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheBlockKey other = (CacheBlockKey)obj;
        if (this.column != other.column) {
            return false;
        }
        if (this.blockId != other.blockId) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.snapshotKey == null ? other.snapshotKey != null : !this.snapshotKey.equals(other.snapshotKey)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "CacheBlockKey [snapshotKey=" + this.snapshotKey + ", " + "type=" + (Object)((Object)this.type) + ", " + "level=" + this.level + ", " + "column=" + this.column + ", " + "blockId=" + this.blockId + "]";
    }
}

