/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.key;

import java.util.Comparator;

public class SnapshotKey
implements Comparable<SnapshotKey> {
    private static final Comparator<SnapshotKey> COMPARATOR = Comparator.comparing(SnapshotKey::getGroupId).thenComparing(SnapshotKey::getSnapshotId);
    public final String groupId;
    public final String snapshotId;

    public SnapshotKey(String groupId, String snapshotId) {
        this.groupId = groupId;
        this.snapshotId = snapshotId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotKey other = (SnapshotKey)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId));
    }

    public String toString() {
        return "SnapshotKey [groupId=" + this.groupId + ", snapshotId=" + this.snapshotId + "]";
    }

    @Override
    public int compareTo(SnapshotKey other) {
        return COMPARATOR.compare(this, other);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }
}

