/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.compress;

import io.datarouter.filesystem.snapshot.compress.BlockCompressor;
import io.datarouter.filesystem.snapshot.compress.ChecksumBlockCompressor;
import io.datarouter.filesystem.snapshot.compress.GzipBlockCompressor;
import io.datarouter.filesystem.snapshot.compress.PassthroughBlockCompressor;
import io.datarouter.util.Require;
import io.datarouter.util.lang.ReflectionTool;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class BlockCompressorRegistry {
    private final Map<String, Class<? extends BlockCompressor>> blockCompressorByName = new HashMap<String, Class<? extends BlockCompressor>>();

    public BlockCompressorRegistry() {
        this.register("passthrough", PassthroughBlockCompressor.class);
        this.register("checksum", ChecksumBlockCompressor.class);
        this.register("gzip", GzipBlockCompressor.class);
    }

    public BlockCompressorRegistry register(String name, Class<? extends BlockCompressor> blockCompressorClass) {
        Require.notContains(this.blockCompressorByName.keySet(), (Object)name);
        this.blockCompressorByName.put(name, blockCompressorClass);
        return this;
    }

    public Class<? extends BlockCompressor> getClass(String name) {
        return this.blockCompressorByName.get(name);
    }

    public BlockCompressor create(String name) {
        Class<? extends BlockCompressor> blockCompressorClass = this.getClass(name);
        return (BlockCompressor)ReflectionTool.create(blockCompressorClass);
    }
}

