/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.value;

import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.encode.ValueBlockEncoder;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import io.datarouter.util.array.PagedObjectArray;
import io.datarouter.util.bytes.IntegerByteTool;
import io.datarouter.util.bytes.VarIntTool;

public class ValueBlockV1Encoder
implements ValueBlockEncoder {
    private int numRecords = 0;
    private int numBytes = 0;
    private final PagedObjectArray<byte[]> values = new PagedObjectArray(256);

    @Override
    public void add(SnapshotEntry entry, int column) {
        ++this.numRecords;
        byte[] value = entry.columnValues[column];
        this.numBytes += value.length;
        this.values.add((Object)value);
    }

    @Override
    public String format() {
        return "valueV1";
    }

    @Override
    public int numRecords() {
        return this.values.size();
    }

    @Override
    public int numBytes() {
        return this.numBytes;
    }

    @Override
    public EncodedBlock encode() {
        byte[] headerChunk = VarIntTool.encode((long)this.numRecords);
        byte[] endingsChunk = new byte[this.values.size() * 4];
        byte[] valuesChunk = new byte[this.numBytes];
        int ending = 0;
        int endingsCursor = 0;
        int valuesCursor = 0;
        for (byte[] value : this.values) {
            int valueLength = value.length;
            IntegerByteTool.toRawBytes((int)(ending += valueLength), (byte[])endingsChunk, (int)endingsCursor);
            endingsCursor += 4;
            System.arraycopy(value, 0, valuesChunk, valuesCursor, valueLength);
            valuesCursor += valueLength;
        }
        byte[][] chunks = new byte[][]{headerChunk, endingsChunk, valuesChunk};
        return new EncodedBlock(chunks);
    }
}

