/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw;

import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.Scanner;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PathService {
    @Inject
    private CheckedPathService checkedPathService;

    public static String pathToString(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) ? String.valueOf(path.toString()) + "/" : path.toString();
    }

    public Scanner<Path> scanChildren(Path fullPath, Set<String> excludingFilenames, int limit, boolean sorted) {
        try {
            return this.checkedPathService.scanChildren(fullPath, excludingFilenames, limit, sorted);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Scanner<Path> scanDescendants(Path fullPath, boolean includeDirectories, boolean sorted) {
        return this.scanChildren(fullPath, Set.of(), Integer.MAX_VALUE, sorted).concat(child -> {
            Scanner childScanner = ObjectScanner.of((Object)child);
            if (Files.isDirectory(child, new LinkOption[0])) {
                return includeDirectories ? Scanner.concat((Scanner[])new Scanner[]{childScanner, this.scanDescendants((Path)child, includeDirectories, sorted)}) : this.scanDescendants((Path)child, includeDirectories, sorted);
            }
            return childScanner;
        });
    }

    public Long size(Path path) {
        try {
            return this.checkedPathService.size(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(Path fullPath) {
        try {
            this.checkedPathService.delete(fullPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Singleton
    public static class CheckedPathService {
        public static final Comparator<Path> PATH_COMPARATOR = Comparator.comparing(PathService::pathToString);

        public Scanner<Path> scanChildren(Path fullPath, Set<String> excludingFilenames, int limit, boolean sorted) throws IOException {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DirectoryStream<Path> iterable = Files.newDirectoryStream(fullPath);){
                Scanner childPaths = Scanner.of(iterable).exclude(path -> excludingFilenames.contains(path.getFileName().toString()));
                if (sorted) {
                    childPaths = childPaths.sort(PATH_COMPARATOR);
                }
                List childPathsList = childPaths.limit((long)limit).list();
                return Scanner.of((Iterable)childPathsList);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public Long size(Path path) throws IOException {
            return Files.size(path);
        }

        public void delete(Path fullPath) throws IOException {
            Files.delete(fullPath);
        }
    }
}

