/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw.small;

import io.datarouter.bytes.split.ChunkScannerTool;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import io.datarouter.util.tuple.Range;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

@Singleton
public class BinaryFileService {
    @Inject
    private CheckedBinaryFileService checkedService;

    public void writeBytes(Path fullPath, byte[] bytes) {
        try {
            this.checkedService.writeBytes(fullPath, bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeBytes(Path fullPath, InputStream inputStream) {
        try {
            this.checkedService.writeBytes(fullPath, inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<Long> length(Path fullPath) {
        try {
            return this.checkedService.length(fullPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<byte[]> readBytes(Path fullPath) {
        try {
            return this.checkedService.readBytes(fullPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<byte[]> readBytes(Path fullPath, long offset, int length) {
        try {
            return this.checkedService.readBytes(fullPath, offset, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Optional<byte[]> readEnding(Path fullPath, int length) {
        try {
            return this.checkedService.readEnding(fullPath, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public InputStream readInputStream(Path fullPath) {
        try {
            return this.checkedService.readInputStream(fullPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Scanner<byte[]> scanChunks(Path fullPath, Range<Long> range, ExecutorService exec, int numThreads, int chunkSize) {
        long fromInclusive = range.hasStart() ? (Long)range.getStart() : 0L;
        long toExclusive = range.hasEnd() ? (Long)range.getEnd() : this.length(fullPath).orElseThrow();
        return ChunkScannerTool.scanChunks((long)fromInclusive, (long)toExclusive, (int)chunkSize).parallelOrdered(new Threads(exec, numThreads)).map(chunkRange -> this.readBytes(fullPath, chunkRange.start, chunkRange.length).orElseThrow());
    }

    @Singleton
    public static class CheckedBinaryFileService {
        public void writeBytes(Path fullPath, byte[] contents) throws IOException {
            fullPath.getParent().toFile().mkdirs();
            Files.write(fullPath, contents, new OpenOption[0]);
        }

        public void writeBytes(Path fullPath, InputStream inputStream) throws IOException {
            fullPath.getParent().toFile().mkdirs();
            fullPath.toFile().createNewFile();
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                inputStream.transferTo(outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public Optional<Long> length(Path fullPath) throws IOException {
            try {
                return Optional.of(Files.size(fullPath));
            }
            catch (NoSuchFileException e) {
                return Optional.empty();
            }
        }

        public Optional<byte[]> readBytes(Path fullPath) throws IOException {
            try {
                return Optional.of(Files.readAllBytes(fullPath));
            }
            catch (NoSuchFileException nsfe) {
                return Optional.empty();
            }
        }

        public Optional<byte[]> readBytes(Path fullPath, long offset, int length) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(length);
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (SeekableByteChannel channel = Files.newByteChannel(fullPath, StandardOpenOption.READ);){
                    channel.position(offset);
                    channel.read(buffer);
                    return Optional.of(buffer.array());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NoSuchFileException nsfe) {
                return Optional.empty();
            }
        }

        public Optional<byte[]> readEnding(Path fullPath, int length) throws IOException {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (SeekableByteChannel channel = Files.newByteChannel(fullPath, StandardOpenOption.READ);){
                    long fileLength = channel.size();
                    int numBytes = Math.toIntExact(Math.min(fileLength, (long)length));
                    ByteBuffer buffer = ByteBuffer.allocate(numBytes);
                    channel.position(fileLength - (long)numBytes);
                    channel.read(buffer);
                    return Optional.of(buffer.array());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (NoSuchFileException nsfe) {
                return Optional.empty();
            }
        }

        public InputStream readInputStream(Path fullPath) throws IOException {
            return new BufferedInputStream(Files.newInputStream(fullPath, new OpenOption[0]));
        }
    }
}

