/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw;

import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.Scanner;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

@Singleton
public class PathService {
    @Inject
    private CheckedPathService checkedPathService;

    public static String pathToString(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) ? path.toString() + "/" : path.toString();
    }

    public List<Path> listChildren(Path fullPath, Set<String> excludingFilenames, int limit, boolean sorted) {
        try {
            return this.checkedPathService.listChildren(fullPath, excludingFilenames, limit, sorted);
        }
        catch (NoSuchFileException e) {
            return List.of();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Scanner<List<Path>> scanDescendantsPaged(Path fullPath, boolean includeDirectories, boolean sorted) {
        return Scanner.of(this.listChildren(fullPath, Set.of(), Integer.MAX_VALUE, sorted)).splitBy(path -> Files.isDirectory(path, new LinkOption[0])).map(Scanner::list).concat(directoriesOrFiles -> {
            boolean isDirectories = Files.isDirectory((Path)directoriesOrFiles.getFirst(), new LinkOption[0]);
            if (isDirectories) {
                List directories = directoriesOrFiles;
                if (includeDirectories) {
                    return Scanner.of((Iterable)directories).concat(directory -> ObjectScanner.of(List.of(directory)).append(this.scanDescendantsPaged((Path)directory, includeDirectories, sorted)));
                }
                return Scanner.of((Iterable)directories).concat(directory -> this.scanDescendantsPaged((Path)directory, includeDirectories, sorted));
            }
            List files = directoriesOrFiles;
            return ObjectScanner.of((Object)files);
        });
    }

    public Long size(Path path) {
        try {
            return this.checkedPathService.size(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(Path fullPath) {
        try {
            this.checkedPathService.delete(fullPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Singleton
    public static class CheckedPathService {
        public static final Comparator<Path> PATH_COMPARATOR = Comparator.comparing(PathService::pathToString);

        public List<Path> listChildren(Path fullPath, Set<String> excludingFilenames, int limit, boolean sorted) throws IOException {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DirectoryStream<Path> iterable = Files.newDirectoryStream(fullPath);){
                Scanner childPaths = Scanner.of(iterable).include(Files::isReadable).exclude(Files::isSymbolicLink).exclude(path -> excludingFilenames.contains(path.getFileName().toString()));
                if (sorted) {
                    childPaths = childPaths.sort(PATH_COMPARATOR);
                }
                return childPaths.limit((long)limit).list();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public Long size(Path path) throws IOException {
            return Files.size(path);
        }

        public void delete(Path fullPath) throws IOException {
            Files.deleteIfExists(fullPath);
        }
    }
}

