/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.client;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsBuilder;
import java.util.Properties;

public class FilesystemClientOptionsBuilder
implements ClientOptionsBuilder {
    private final String clientIdName;
    private final Properties properties;

    public FilesystemClientOptionsBuilder(ClientId clientId) {
        this.clientIdName = clientId.getName();
        this.properties = new Properties();
        this.properties.setProperty(this.makeKey("type"), "filesystem");
    }

    public FilesystemClientOptionsBuilder withRoot(String rootPathString) {
        String optionKey = this.makeKey("root");
        this.properties.setProperty(optionKey, rootPathString);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private String makeKey(String suffix) {
        return ClientOptions.makeClientPrefixedKey((String)this.clientIdName, (String)suffix);
    }
}

