/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group.groupops;

import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.path.SnapshotPathsRegistry;
import io.datarouter.filesystem.snapshot.storage.file.SnapshotFileDeleter;
import io.datarouter.filesystem.snapshot.storage.file.SnapshotFileStorage;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.util.Subpath;
import java.util.concurrent.ExecutorService;

public class SnapshotGroupDeleteOps {
    private final SnapshotGroup group;
    private final SnapshotPathsRegistry pathsRegistry;
    private final Directory groupDirectory;
    private final Directory idDirectory;
    private final Directory fileDirectory;

    public SnapshotGroupDeleteOps(SnapshotGroup group, SnapshotPathsRegistry pathsRegistry, Directory groupSubpath, Directory idSubpath, Directory fileSubpath) {
        this.group = group;
        this.pathsRegistry = pathsRegistry;
        this.groupDirectory = groupSubpath;
        this.idDirectory = idSubpath;
        this.fileDirectory = fileSubpath;
    }

    public void deleteSnapshot(SnapshotKey snapshotKey, ExecutorService exec, int numThreads) {
        this.deleteIdFile(snapshotKey.snapshotId);
        RootBlock rootBlock = this.group.root(BlockKey.root(snapshotKey));
        SnapshotFileStorage snapshotFileStorage = this.group.makeSnapshotFileStorage(snapshotKey.snapshotId);
        new SnapshotFileDeleter(rootBlock, this.pathsRegistry, snapshotKey, snapshotFileStorage, exec, numThreads).delete();
    }

    public void deleteGroup(ExecutorService exec, int numThreads) {
        this.idDirectory.scanKeys(Subpath.empty()).parallel(new ParallelScannerContext(exec, numThreads, true)).forEach(arg_0 -> ((Directory)this.idDirectory).delete(arg_0));
        this.fileDirectory.scanKeys(Subpath.empty()).parallel(new ParallelScannerContext(exec, numThreads, true)).forEach(arg_0 -> ((Directory)this.fileDirectory).delete(arg_0));
        this.groupDirectory.deleteAll(Subpath.empty());
    }

    private void deleteIdFile(String snapshotId) {
        this.idDirectory.delete(PathbeanKey.of((String)snapshotId));
    }
}

