/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group.dto;

import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotKeyAndRoot;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.util.Require;
import java.util.Optional;

public class SnapshotWriteResult {
    public final SnapshotKey key;
    public final boolean success;
    public final Optional<RootBlock> optRoot;

    private SnapshotWriteResult(SnapshotKey key, boolean success, RootBlock root) {
        this.key = key;
        this.success = success;
        this.optRoot = Optional.ofNullable(root);
    }

    public static SnapshotWriteResult success(SnapshotKey key, RootBlock root) {
        return new SnapshotWriteResult(key, true, root);
    }

    public static SnapshotWriteResult empty(SnapshotKey key) {
        return new SnapshotWriteResult(key, false, null);
    }

    public static SnapshotWriteResult failure(SnapshotKey key) {
        return new SnapshotWriteResult(key, false, null);
    }

    public void assertSuccess() {
        Require.isTrue((boolean)this.success);
    }

    public SnapshotKeyAndRoot toSnapshotKeyAndRoot() {
        return new SnapshotKeyAndRoot(this.key, this.optRoot.orElseThrow());
    }
}

