/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.group;

import io.datarouter.filesystem.snapshot.block.Block;
import io.datarouter.filesystem.snapshot.block.BlockKey;
import io.datarouter.filesystem.snapshot.block.leaf.LeafBlock;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.encode.RootBlockDecoder;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupDeleteOps;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupFileReadOps;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupKeyReadOps;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupVacuumOps;
import io.datarouter.filesystem.snapshot.group.groupops.SnapshotGroupWriteOps;
import io.datarouter.filesystem.snapshot.group.vacuum.SnapshotVacuumConfig;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.key.SnapshotKeyDecoder;
import io.datarouter.filesystem.snapshot.path.SnapshotPathsRegistry;
import io.datarouter.filesystem.snapshot.reader.block.BlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.DecodingBlockLoader;
import io.datarouter.filesystem.snapshot.reader.block.DecodingBlockLoaderFactory;
import io.datarouter.filesystem.snapshot.reader.block.LeafBlockRangeLoader;
import io.datarouter.filesystem.snapshot.storage.block.BlobStorageSnapshotBlockStorage;
import io.datarouter.filesystem.snapshot.storage.block.CachingBlockStorageReader;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorage;
import io.datarouter.filesystem.snapshot.storage.block.SnapshotBlockStorageReader;
import io.datarouter.filesystem.snapshot.storage.file.BlobStorageSnapshotFileStorage;
import io.datarouter.filesystem.snapshot.storage.file.SnapshotFileStorage;
import io.datarouter.filesystem.snapshot.web.SnapshotRecordStringDecoder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Directory;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.lang.ReflectionTool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SnapshotGroup
implements BlockLoader {
    private static final Subpath ID = new Subpath(new String[]{"id"});
    private static final Subpath FILE = new Subpath(new String[]{"file"});
    private final String groupId;
    private final SnapshotPathsRegistry pathsRegistry;
    private final RootBlockDecoder rootBlockDecoder;
    private final DecodingBlockLoaderFactory decodingBlockLoaderFactory;
    private final Directory directory;
    private final Directory cacheDirectory;
    private final SnapshotKeyDecoder snapshotKeyDecoder;
    private final Class<? extends SnapshotRecordStringDecoder> snapshotRecordDecoderClass;
    private final SnapshotVacuumConfig vacuumConfig;
    private final Directory idDirectory;
    private final Directory fileDirectory;
    private final Map<SnapshotKey, DecodingBlockLoader> decodingBlockLoaderBySnapshotKey;

    public SnapshotGroup(String groupId, SnapshotPathsRegistry pathsRegistry, RootBlockDecoder rootBlockDecoder, DecodingBlockLoaderFactory decodingBlockLoaderFactory, Directory directory, Directory cacheDirectory, Class<? extends SnapshotKeyDecoder> snapshotKeyDecoderClass, Class<? extends SnapshotRecordStringDecoder> snapshotRecordDecoderClass, SnapshotVacuumConfig vacuumConfig) {
        this.groupId = groupId;
        this.pathsRegistry = pathsRegistry;
        this.rootBlockDecoder = rootBlockDecoder;
        this.decodingBlockLoaderFactory = decodingBlockLoaderFactory;
        this.directory = directory;
        this.cacheDirectory = cacheDirectory;
        this.snapshotKeyDecoder = (SnapshotKeyDecoder)ReflectionTool.create(snapshotKeyDecoderClass);
        this.snapshotRecordDecoderClass = snapshotRecordDecoderClass;
        this.vacuumConfig = vacuumConfig;
        this.idDirectory = directory.subdirectory(ID);
        this.fileDirectory = directory.subdirectory(FILE);
        this.decodingBlockLoaderBySnapshotKey = new ConcurrentHashMap<SnapshotKey, DecodingBlockLoader>();
    }

    public SnapshotGroupWriteOps writeOps() {
        return new SnapshotGroupWriteOps(this, this.groupId, this.decodingBlockLoaderFactory, this.cacheDirectory, this.idDirectory, this.decodingBlockLoaderBySnapshotKey);
    }

    public SnapshotGroupFileReadOps fileReadOps() {
        return new SnapshotGroupFileReadOps(this.groupId, this.idDirectory, this.fileDirectory);
    }

    public SnapshotGroupKeyReadOps keyReadOps(boolean cacheOk) {
        return new SnapshotGroupKeyReadOps(this, this.fileReadOps(), this.snapshotKeyDecoder, cacheOk);
    }

    public SnapshotGroupDeleteOps deleteOps() {
        return new SnapshotGroupDeleteOps(this, this.pathsRegistry, this.directory, this.idDirectory, this.fileDirectory);
    }

    public SnapshotGroupVacuumOps vacuumOps() {
        return new SnapshotGroupVacuumOps(this, this.groupId, this.fileDirectory, this.snapshotKeyDecoder, this.vacuumConfig, this.fileReadOps(), this.keyReadOps(false));
    }

    @Override
    public Block get(BlockKey blockKey) {
        return this.blockLoader(blockKey.snapshotKey).get(blockKey);
    }

    @Override
    public Scanner<LeafBlock> leafRange(LeafBlockRangeLoader.LeafBlockRange range) {
        return this.blockLoader(range.snapshotKey).leafRange(range);
    }

    private DecodingBlockLoader blockLoader(SnapshotKey snapshotKey) {
        return this.decodingBlockLoaderBySnapshotKey.computeIfAbsent(snapshotKey, $ -> this.makeDecodingBlockLoader(snapshotKey));
    }

    public String getDirectoryLocation() {
        return String.format("%s:%s", this.directory.getBucket(), this.directory.getRootPath());
    }

    public String getGroupId() {
        return this.groupId;
    }

    public SnapshotKey getSnapshotKey(String snapshotId) {
        return new SnapshotKey(this.groupId, snapshotId);
    }

    public Class<? extends SnapshotRecordStringDecoder> getSnapshotEntryDecoderClass() {
        return this.snapshotRecordDecoderClass;
    }

    private DecodingBlockLoader makeDecodingBlockLoader(SnapshotKey snapshotKey) {
        SnapshotBlockStorageReader blockStorageReader = this.makeStorageReader(snapshotKey.snapshotId);
        byte[] rootBytes = blockStorageReader.getRootBlock();
        RootBlock rootBlock = this.rootBlockDecoder.decode(rootBytes);
        return this.decodingBlockLoaderFactory.create(rootBlock, blockStorageReader);
    }

    public SnapshotBlockStorageReader makeStorageReader(String snapshotId) {
        SnapshotFileStorage snapshotFileStorage = this.makeSnapshotFileStorage(snapshotId);
        return this.cacheDirectory == null ? snapshotFileStorage : new CachingBlockStorageReader(snapshotFileStorage, this.makeCacheStorage(snapshotId));
    }

    public SnapshotFileStorage makeSnapshotFileStorage(String snapshotId) {
        return new BlobStorageSnapshotFileStorage(this.fileDirectory.subdirectory(new Subpath(new String[]{snapshotId})));
    }

    public SnapshotBlockStorage makeCacheStorage(String snapshotId) {
        return new BlobStorageSnapshotBlockStorage(this.cacheDirectory.subdirectory(new Subpath(new String[]{snapshotId})));
    }
}

