/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.root;

import io.datarouter.bytes.ByteReader;
import io.datarouter.filesystem.snapshot.block.BlockSizeCalculator;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.scanner.Scanner;
import java.util.Arrays;

public class RootBlockV1
implements RootBlock {
    public static final String FORMAT = "rootV1";
    private static final int HEAP_SIZE_OVERHEAD = new BlockSizeCalculator().addObjectHeaders(1).addInts(9).addLongs(7).addRefs(14).calculate();
    private final int numRootBytesEncoded;
    private final boolean sorted;
    private final String pathFormat;
    private final String branchBlockType;
    private final String leafBlockType;
    private final String valueBlockType;
    private final String branchBlockCompressor;
    private final String leafBlockCompressor;
    private final String valueBlockCompressor;
    private final int branchBytesPerFile;
    private final int leafBytesPerFile;
    private final int valueBytesPerFile;
    private final int branchBlocksPerFile;
    private final int leafBlocksPerFile;
    private final int valueBlocksPerFile;
    private final long numItems;
    private final int numBranchLevels;
    private final int[] numBranchBlocksByLevel;
    private final int numBranchBlocks;
    private final int numLeafBlocks;
    private final int numColumns;
    private final int[] numValueBlocksByColumn;
    private final int numValueBlocks;
    private final long numBranchBytesEncoded;
    private final long numLeafBytesEncoded;
    private final long numValueBytesEncoded;
    private final long numBranchBytesCompressed;
    private final long numLeafBytesCompressed;
    private final long numValueBytesCompressed;
    private final long writeStartTimeMs;
    private final long writeDurationMs;
    private final int rootBranchBlockEnding;
    private final byte[][] dictionaryKeys;
    private final byte[][] dictionaryValues;

    public RootBlockV1(byte[] bytes) {
        this.numRootBytesEncoded = bytes.length;
        ByteReader reader = new ByteReader(bytes);
        reader.varUtf8();
        this.sorted = reader.booleanByte();
        this.pathFormat = reader.varUtf8();
        this.branchBlockType = reader.varUtf8();
        this.leafBlockType = reader.varUtf8();
        this.valueBlockType = reader.varUtf8();
        this.branchBlockCompressor = reader.varUtf8();
        this.leafBlockCompressor = reader.varUtf8();
        this.valueBlockCompressor = reader.varUtf8();
        this.branchBytesPerFile = reader.varInt();
        this.leafBytesPerFile = reader.varInt();
        this.valueBytesPerFile = reader.varInt();
        this.branchBlocksPerFile = reader.varInt();
        this.leafBlocksPerFile = reader.varInt();
        this.valueBlocksPerFile = reader.varInt();
        this.numItems = reader.varLong();
        this.numBranchLevels = reader.varInt();
        this.numBranchBlocksByLevel = reader.varInts(this.numBranchLevels);
        this.numBranchBlocks = Arrays.stream(this.numBranchBlocksByLevel).sum();
        this.numLeafBlocks = reader.varInt();
        this.numColumns = reader.varInt();
        this.numValueBlocksByColumn = reader.varInts(this.numColumns);
        this.numValueBlocks = Arrays.stream(this.numValueBlocksByColumn).sum();
        this.numBranchBytesEncoded = reader.varLong();
        this.numLeafBytesEncoded = reader.varLong();
        this.numValueBytesEncoded = reader.varLong();
        this.numBranchBytesCompressed = reader.varLong();
        this.numLeafBytesCompressed = reader.varLong();
        this.numValueBytesCompressed = reader.varLong();
        this.writeStartTimeMs = reader.varLong();
        this.writeDurationMs = reader.varLong();
        this.rootBranchBlockEnding = reader.varInt();
        int numDictionaryEntries = reader.varInt();
        this.dictionaryKeys = new byte[numDictionaryEntries][];
        this.dictionaryValues = new byte[numDictionaryEntries][];
        int i = 0;
        while (i < numDictionaryEntries) {
            this.dictionaryKeys[i] = reader.varBytes();
            this.dictionaryValues[i] = reader.varBytes();
            ++i;
        }
    }

    @Override
    public int heapSize() {
        BlockSizeCalculator calculator = new BlockSizeCalculator().addStringValue(this.pathFormat).addStringValue(this.branchBlockType).addStringValue(this.leafBlockType).addStringValue(this.valueBlockType).addStringValue(this.branchBlockCompressor).addStringValue(this.leafBlockCompressor).addStringValue(this.valueBlockCompressor).addIntArrayValue(this.numBranchBlocksByLevel).addIntArrayValue(this.numValueBlocksByColumn);
        Scanner.of((Object[])this.dictionaryKeys).forEach(calculator::addByteArrayValue);
        Scanner.of((Object[])this.dictionaryValues).forEach(calculator::addByteArrayValue);
        return HEAP_SIZE_OVERHEAD + calculator.calculate();
    }

    @Override
    public boolean sorted() {
        return this.sorted;
    }

    @Override
    public String pathFormat() {
        return this.pathFormat;
    }

    @Override
    public String branchBlockType() {
        return this.branchBlockType;
    }

    @Override
    public String leafBlockType() {
        return this.leafBlockType;
    }

    @Override
    public String valueBlockType() {
        return this.valueBlockType;
    }

    @Override
    public String branchBlockCompressor() {
        return this.branchBlockCompressor;
    }

    @Override
    public String leafBlockCompressor() {
        return this.leafBlockCompressor;
    }

    @Override
    public String valueBlockCompressor() {
        return this.valueBlockCompressor;
    }

    @Override
    public int branchBytesPerFile() {
        return this.branchBytesPerFile;
    }

    @Override
    public int leafBytesPerFile() {
        return this.leafBytesPerFile;
    }

    @Override
    public int valueBytesPerFile() {
        return this.valueBytesPerFile;
    }

    @Override
    public int branchBlocksPerFile() {
        return this.branchBlocksPerFile;
    }

    @Override
    public int leafBlocksPerFile() {
        return this.leafBlocksPerFile;
    }

    @Override
    public int valueBlocksPerFile() {
        return this.valueBlocksPerFile;
    }

    @Override
    public long numItems() {
        return this.numItems;
    }

    @Override
    public int numBranchLevels() {
        return this.numBranchLevels;
    }

    @Override
    public int numBranchBlocks() {
        return this.numBranchBlocks;
    }

    @Override
    public int numBranchBlocks(int level) {
        return this.numBranchBlocksByLevel[level];
    }

    @Override
    public int numLeafBlocks() {
        return this.numLeafBlocks;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int numValueBlocks(int column) {
        return this.numValueBlocksByColumn[column];
    }

    @Override
    public int numValueBlocks() {
        return this.numValueBlocks;
    }

    @Override
    public long numRootBytesEncoded() {
        return this.numRootBytesEncoded;
    }

    @Override
    public long numBranchBytesEncoded() {
        return this.numBranchBytesEncoded;
    }

    @Override
    public long numLeafBytesEncoded() {
        return this.numLeafBytesEncoded;
    }

    @Override
    public long numValueBytesEncoded() {
        return this.numValueBytesEncoded;
    }

    @Override
    public long numBranchBytesCompressed() {
        return this.numBranchBytesCompressed;
    }

    @Override
    public long numLeafBytesCompressed() {
        return this.numLeafBytesCompressed;
    }

    @Override
    public long numValueBytesCompressed() {
        return this.numValueBytesCompressed;
    }

    @Override
    public long writeStartTimeMs() {
        return this.writeStartTimeMs;
    }

    @Override
    public long writeDurationMs() {
        return this.writeDurationMs;
    }

    @Override
    public int rootBranchBlockEnding() {
        return this.rootBranchBlockEnding;
    }

    @Override
    public int numDictionaryEntries() {
        return this.dictionaryKeys.length;
    }

    @Override
    public byte[] dictionaryKey(int index) {
        return this.dictionaryKeys[index];
    }

    @Override
    public byte[] dictionaryValue(int index) {
        return this.dictionaryValues[index];
    }
}

