/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.block.leaf;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.ByteWriter;
import io.datarouter.bytes.PagedObjectArray;
import io.datarouter.bytes.codec.bytestringcodec.CsvIntByteStringCodec;
import io.datarouter.bytes.codec.intcodec.RawIntCodec;
import io.datarouter.filesystem.snapshot.encode.EncodedBlock;
import io.datarouter.filesystem.snapshot.encode.LeafBlockEncoder;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import io.datarouter.filesystem.snapshot.writer.BlockQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class LeafBlockV1Encoder
implements LeafBlockEncoder {
    private static final RawIntCodec RAW_INT_CODEC = RawIntCodec.INSTANCE;
    private final int leafEncoderChunkSize;
    private int blockId;
    private long firstRecordId;
    private int numRecords;
    private int numKeyBytes;
    private int numValueBytes;
    private int numBytes;
    private final PagedObjectArray<SnapshotEntry> entries;
    private int numColumns;
    private int[] firstValueBlockIds;
    private int[] firstValueIndexes;
    private int[] latestValueBlockIds;
    private List<List<Integer>> valueBlockOffsets;

    public LeafBlockV1Encoder(int leafEncoderChunkSize) {
        this.leafEncoderChunkSize = leafEncoderChunkSize;
        this.firstRecordId = -1L;
        this.numRecords = 0;
        this.numKeyBytes = 0;
        this.numValueBytes = 0;
        this.numBytes = 0;
        this.entries = new PagedObjectArray(256);
    }

    @Override
    public String format() {
        return "keyV1";
    }

    @Override
    public void add(int blockId, long recordId, SnapshotEntry entry, int[] valueBlockIds, int[] valueIndexes) {
        int column;
        this.blockId = blockId;
        if (this.numRecords == 0) {
            this.firstRecordId = recordId;
            this.firstValueBlockIds = valueBlockIds;
            this.firstValueIndexes = valueIndexes;
            this.numColumns = valueBlockIds.length;
            this.latestValueBlockIds = new int[this.numColumns];
            this.valueBlockOffsets = new ArrayList<List<Integer>>();
            column = 0;
            while (column < this.numColumns) {
                this.latestValueBlockIds[column] = -1;
                this.valueBlockOffsets.add(new ArrayList());
                ++column;
            }
        }
        column = 0;
        while (column < this.numColumns) {
            if (valueBlockIds[column] != this.latestValueBlockIds[column]) {
                this.valueBlockOffsets.get(column).add(this.numRecords);
                this.latestValueBlockIds[column] = valueBlockIds[column];
            }
            ++column;
        }
        ++this.numRecords;
        this.numKeyBytes += entry.keyLength();
        this.numValueBytes += entry.valueLength();
        this.numBytes = this.numKeyBytes + this.numValueBytes;
        this.entries.add((Object)entry);
    }

    @Override
    public int numRecords() {
        return this.entries.size();
    }

    @Override
    public int numBytes() {
        return this.numBytes;
    }

    @Override
    public byte[] firstKey() {
        return ((SnapshotEntry)this.entries.get(0)).key();
    }

    @Override
    public void assertKeysSorted() {
        Iterator iter = this.entries.iterator();
        SnapshotEntry previous = null;
        while (iter.hasNext()) {
            SnapshotEntry current = (SnapshotEntry)iter.next();
            if (previous != null && !SnapshotEntry.isSorted(previous, current, false)) {
                String message = String.format("key=[%s] must sort after previous=[%s]", CsvIntByteStringCodec.INSTANCE.encode(current.key()), CsvIntByteStringCodec.INSTANCE.encode(previous.key()));
                throw new IllegalStateException(message);
            }
            previous = current;
        }
    }

    @Override
    public int blockId() {
        return this.blockId;
    }

    @Override
    public int firstValueBlockId(int column) {
        return this.firstValueBlockIds[column];
    }

    @Override
    public int numValueBlocks(int column) {
        return this.valueBlockOffsets.get(column).size();
    }

    @Override
    public EncodedBlock encode(BlockQueue.FileIdsAndEndings[] fileIdsAndEndings) {
        ByteWriter headerWriter = new ByteWriter(32);
        headerWriter.varLong(this.firstRecordId);
        headerWriter.varInt(this.numRecords);
        headerWriter.varInt(this.numColumns);
        byte[] keyEndings = new byte[this.entries.size() * 4];
        int latestKeyEnding = 0;
        byte[] valueEndings = new byte[this.entries.size() * 4];
        int latestValueEnding = 0;
        int cursor = 0;
        for (SnapshotEntry entry : this.entries) {
            RAW_INT_CODEC.encode(latestKeyEnding += entry.keyLength(), keyEndings, cursor);
            RAW_INT_CODEC.encode(latestValueEnding += entry.valueLength(), valueEndings, cursor);
            cursor += 4;
        }
        byte[] keys = new byte[this.numKeyBytes];
        int keyCursor = 0;
        byte[] values = new byte[this.numValueBytes];
        int valueCursor = 0;
        for (SnapshotEntry entry : this.entries) {
            int keyLength = entry.keyLength();
            System.arraycopy(entry.keySlab(), entry.keyFrom(), keys, keyCursor, keyLength);
            keyCursor += keyLength;
            int valueLength = entry.valueLength();
            System.arraycopy(entry.valueSlab(), entry.valueFrom(), values, valueCursor, valueLength);
            valueCursor += valueLength;
        }
        ByteWriter[] columnWriters = new ByteWriter[this.numColumns];
        int column = 0;
        while (column < this.numColumns) {
            ByteWriter columnWriter;
            columnWriters[column] = columnWriter = new ByteWriter(this.leafEncoderChunkSize);
            columnWriter.varInt(this.firstValueBlockIds[column]);
            columnWriter.varInt(fileIdsAndEndings[column].fileIds.length);
            columnWriter.rawInts(fileIdsAndEndings[column].fileIds);
            columnWriter.varInt(fileIdsAndEndings[column].endings.length);
            columnWriter.rawInts(fileIdsAndEndings[column].endings);
            columnWriter.varInt(this.firstValueIndexes[column]);
            columnWriter.varInt(this.valueBlockOffsets.get(column).size());
            this.valueBlockOffsets.get(column).forEach(arg_0 -> ((ByteWriter)columnWriter).rawInt(arg_0));
            ++column;
        }
        ArrayList<Object> chunks = new ArrayList<Object>();
        chunks.addAll(Arrays.asList(headerWriter.trimmedPages()));
        chunks.add(keyEndings);
        chunks.add(keys);
        chunks.add(valueEndings);
        chunks.add(values);
        Arrays.stream(columnWriters).map(ByteWriter::trimmedPages).map(byArray -> Arrays.asList(byArray)).forEach(chunks::addAll);
        return new EncodedBlock((byte[][])chunks.toArray((T[])ByteTool.EMPTY_ARRAY_2));
    }
}

