/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.raw.small;

import io.datarouter.bytes.split.ChunkScannerTool;
import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BinaryFileService {
    @Inject
    private CheckedBinaryFileService checkedService;

    public void writeBytes(Path fullPath, byte[] contents) {
        this.writeBytes(fullPath, (Scanner<byte[]>)ObjectScanner.of((Object)contents));
    }

    public void writeBytes(Path fullPath, Scanner<byte[]> chunks) {
        try {
            this.checkedService.writeBytes(fullPath, chunks);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeBytes(Path fullPath, InputStream inputStream) {
        try {
            this.checkedService.writeBytes(fullPath, inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<Long> length(Path fullPath) {
        try {
            return this.checkedService.length(fullPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] readBytes(Path fullPath) {
        try {
            return this.checkedService.readBytes(fullPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] readBytes(Path fullPath, long offset, int length) {
        try {
            return this.checkedService.readBytes(fullPath, offset, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Scanner<byte[]> scanChunks(Path fullPath, ExecutorService exec, int numThreads, int chunkSize) {
        long totalLength = this.length(fullPath).orElseThrow();
        return ChunkScannerTool.scanChunks((long)totalLength, (int)chunkSize).parallel(new ParallelScannerContext(exec, numThreads, false)).map(range -> this.readBytes(fullPath, range.start, range.length));
    }

    @Singleton
    public static class CheckedBinaryFileService {
        public void writeBytes(Path fullPath, byte[] contents) throws IOException {
            this.writeBytes(fullPath, (Scanner<byte[]>)ObjectScanner.of((Object)contents));
        }

        public void writeBytes(Path fullPath, Scanner<byte[]> chunks) throws IOException {
            fullPath.getParent().toFile().mkdirs();
            fullPath.toFile().createNewFile();
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                for (byte[] chunk : chunks.iterable()) {
                    outputStream.write(chunk);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public void writeBytes(Path fullPath, InputStream inputStream) throws IOException {
            fullPath.getParent().toFile().mkdirs();
            fullPath.toFile().createNewFile();
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                inputStream.transferTo(outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public Optional<Long> length(Path fullPath) throws IOException {
            try {
                return Optional.of(Files.size(fullPath));
            }
            catch (NoSuchFileException e) {
                return Optional.empty();
            }
        }

        public byte[] readBytes(Path fullPath) throws IOException {
            return Files.readAllBytes(fullPath);
        }

        public byte[] readBytes(Path fullPath, long offset, int length) throws IOException {
            ByteBuffer buffer = ByteBuffer.allocate(length);
            Throwable throwable = null;
            Object var7_7 = null;
            try (SeekableByteChannel channel = Files.newByteChannel(fullPath, StandardOpenOption.READ);){
                channel.position(offset);
                channel.read(buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return buffer.array();
        }
    }
}

