/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.client;

import io.datarouter.filesystem.client.FilesystemClientType;
import io.datarouter.filesystem.client.FilesystemNodeFactory;
import io.datarouter.filesystem.client.FilesystemOptions;
import io.datarouter.filesystem.node.object.DirectoryBlobStorage;
import io.datarouter.filesystem.node.object.DirectoryBlobStorageNode;
import io.datarouter.filesystem.node.queue.DirectoryGroupQueueNode;
import io.datarouter.filesystem.node.queue.DirectoryQueueNode;
import io.datarouter.filesystem.raw.DirectoryManager;
import io.datarouter.filesystem.raw.queue.DirectoryQueue;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.client.imp.QueueClientNodeFactory;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.adapter.NodeAdapters;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.web.config.service.ServiceName;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FilesystemClientNodeFactory
implements BlobClientNodeFactory,
QueueClientNodeFactory {
    @Inject
    private FilesystemClientType clientType;
    @Inject
    private ServiceName serviceName;
    @Inject
    private FilesystemNodeFactory filesystemNodeFactory;
    @Inject
    private DirectoryManager.DirectoryManagerFactory directoryManagerFactory;
    @Inject
    private FilesystemOptions filesystemOptions;
    @Inject
    private NodeAdapters nodeAdapters;

    public BlobStorage.PhysicalBlobStorageNode createBlobNode(NodeParams<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> nodeParams) {
        DirectoryBlobStorage directoryBlobStorage = this.makeDirectoryObjectStorage(nodeParams);
        DirectoryBlobStorageNode node = new DirectoryBlobStorageNode(nodeParams, this.clientType, directoryBlobStorage, nodeParams.getPhysicalName(), nodeParams.getPath());
        return this.nodeAdapters.wrapBlobNode((BlobStorage.PhysicalBlobStorageNode)node);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createSingleQueueNode(NodeParams<PK, D, F> nodeParams) {
        DirectoryQueueNode<PK, D, F> node = this.filesystemNodeFactory.createSingleNode(this.makeDirectoryQueue(nodeParams), nodeParams);
        return this.nodeAdapters.wrapQueueNode(node);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> PhysicalNode<PK, D, F> createGroupQueueNode(NodeParams<PK, D, F> nodeParams) {
        DirectoryGroupQueueNode<PK, D, F> node = this.filesystemNodeFactory.createGroupNode(this.makeDirectoryQueue(nodeParams), nodeParams);
        return this.nodeAdapters.wrapGroupQueueNode(node);
    }

    private DirectoryBlobStorage makeDirectoryObjectStorage(NodeParams<?, ?, ?> nodeParams) {
        Path rootPath = this.filesystemOptions.getRoot(nodeParams.getClientName());
        String relativePathString = (String)Scanner.of((Object[])new String[]{nodeParams.getPhysicalName(), nodeParams.getPath().toString()}).exclude(Objects::isNull).collect(Collectors.joining("/"));
        Path relativePath = Paths.get(relativePathString, new String[0]);
        Path fullPath = rootPath.resolve(relativePath);
        DirectoryManager directoryManager = this.directoryManagerFactory.create(fullPath.toString());
        return new DirectoryBlobStorage(directoryManager);
    }

    private DirectoryQueue makeDirectoryQueue(NodeParams<?, ?, ?> nodeParams) {
        Path rootPath = this.filesystemOptions.getRoot(nodeParams.getClientName());
        String relativePathString = String.join((CharSequence)"/", this.serviceName.get(), nodeParams.getPhysicalName());
        Path relativePath = Paths.get(relativePathString, new String[0]);
        Path fullPath = rootPath.resolve(relativePath);
        DirectoryManager directoryManager = this.directoryManagerFactory.create(fullPath.toString());
        return new DirectoryQueue(directoryManager);
    }
}

