/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.path;

import io.datarouter.filesystem.snapshot.path.SnapshotPaths;
import io.datarouter.filesystem.snapshot.path.SnapshotPathsV1;
import io.datarouter.util.Require;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;

@Singleton
public class SnapshotPathsRegistry {
    private final Map<String, SnapshotPaths> byName = new ConcurrentHashMap<String, SnapshotPaths>();

    public SnapshotPathsRegistry() {
        this.register("pathsV1", new SnapshotPathsV1());
    }

    public void register(String name, SnapshotPaths snapshotPaths) {
        Require.notContains(this.byName.keySet(), (Object)name);
        this.byName.put(name, snapshotPaths);
    }

    public SnapshotPaths getPaths(String name) {
        SnapshotPaths paths = this.byName.get(name);
        if (paths == null) {
            String message = String.format("Path implementation not found: %s", name);
            throw new IllegalArgumentException(message);
        }
        return paths;
    }
}

