/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.filesystem.snapshot.benchmark;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;
import io.datarouter.filesystem.snapshot.block.root.RootBlock;
import io.datarouter.filesystem.snapshot.compress.PassthroughBlockCompressor;
import io.datarouter.filesystem.snapshot.entry.SnapshotEntry;
import io.datarouter.filesystem.snapshot.group.SnapshotGroup;
import io.datarouter.filesystem.snapshot.group.dto.SnapshotWriteResult;
import io.datarouter.filesystem.snapshot.key.SnapshotKey;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriterConfig;
import io.datarouter.filesystem.snapshot.writer.SnapshotWriterConfigBuilder;
import io.datarouter.scanner.ParallelScannerContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.concurrent.ExecutorServiceTool;
import io.datarouter.util.number.NumberFormatter;
import io.datarouter.util.timer.PhaseTimer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotBenchmark {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotBenchmark.class);
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;
    private static final int KEY_LENGTH = 8;
    private static final int VALUE_LENGTH = 8;
    public static final int WRITE_BATCH_SIZE = 10000;
    public final SnapshotGroup group;
    private final int numInputThreads;
    private final ExecutorService scannerExec;
    private final int numWriterThreads;
    private final ExecutorService writerExec;
    public final long numEntries;
    public final int writeBatchSize;
    public final boolean persist;
    public SnapshotKey snapshotKey;

    public SnapshotBenchmark(SnapshotGroup group, int numInputThreads, int numWriterThreads, long numEntries, int writeBatchSize, boolean persist) {
        this.group = group;
        this.scannerExec = Executors.newFixedThreadPool(numInputThreads);
        this.numInputThreads = numInputThreads;
        this.writerExec = Executors.newFixedThreadPool(numWriterThreads);
        this.numWriterThreads = numWriterThreads;
        this.numEntries = numEntries;
        this.writeBatchSize = writeBatchSize;
        this.persist = persist;
    }

    public RootBlock execute() {
        PhaseTimer timer = new PhaseTimer("writeSnapshot");
        SnapshotWriteResult result = (SnapshotWriteResult)this.makeEntryScanner(this.scannerExec, this.numInputThreads).apply(entries -> this.group.writeOps().write(this.makeSnapshotWriterConfig(), (Scanner<List<SnapshotEntry>>)entries, this.writerExec, () -> false));
        this.snapshotKey = result.key;
        timer.add("wrote " + NumberFormatter.addCommas((Number)result.optRoot.get().numItems()));
        logger.warn("{} @{}/s", (Object)timer, (Object)NumberFormatter.addCommas((Number)Float.valueOf(timer.getItemsPerSecond(this.numEntries))));
        return result.optRoot.get();
    }

    public void cleanup() {
        this.group.deleteOps().deleteSnapshot(this.snapshotKey, this.writerExec, this.numWriterThreads);
        this.group.deleteOps().deleteGroup(this.writerExec, this.numWriterThreads);
    }

    public void shutdown() {
        ExecutorServiceTool.shutdown((ExecutorService)this.scannerExec, (Duration)Duration.ofSeconds(2L));
        ExecutorServiceTool.shutdown((ExecutorService)this.writerExec, (Duration)Duration.ofSeconds(2L));
    }

    private SnapshotWriterConfig makeSnapshotWriterConfig() {
        return new SnapshotWriterConfigBuilder(true, 0).withPersist(this.persist).withCompressor(new PassthroughBlockCompressor()).withNumThreads(this.numWriterThreads).build();
    }

    public Scanner<List<SnapshotEntry>> makeEntryScanner(ExecutorService exec, int numThreads) {
        return Scanner.iterate((Object)0L, id -> id + (long)this.writeBatchSize).advanceWhile(id -> id < this.numEntries).parallel(new ParallelScannerContext(exec, numThreads, false)).map(from -> SnapshotBenchmark.makeEntries(from, this.writeBatchSize));
    }

    public static List<SnapshotEntry> makeEntries(long from, int limit) {
        byte[] keySlab = new byte[8 * limit];
        byte[] valueSlab = new byte[8 * limit];
        SnapshotEntry[] entries = new SnapshotEntry[limit];
        int i = 0;
        while (i < limit) {
            long id = from + (long)i;
            int keyFrom = i * 8;
            int keyTo = keyFrom + 8;
            RAW_LONG_CODEC.encode(id, keySlab, keyFrom);
            int valueFrom = i * 8;
            int valueTo = valueFrom + 8;
            RAW_LONG_CODEC.encode(id, valueSlab, valueFrom);
            entries[i] = new SnapshotEntry(keySlab, keyFrom, keyTo, valueSlab, valueFrom, valueTo, ByteTool.EMPTY_ARRAY_2);
            ++i;
        }
        return Arrays.asList(entries);
    }

    public static byte[] makeKey(long id) {
        return RAW_LONG_CODEC.encode(id);
    }

    public static byte[] makeValue(long id) {
        return RAW_LONG_CODEC.encode(id);
    }
}

